/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;

public class StdXMLReader {
    private final Deque<StackedReader> readers;
    private StackedReader currentReader;

    public StdXMLReader(String publicID, String systemID) throws MalformedURLException, FileNotFoundException, IOException {
        URL systemIDasURL;
        try {
            systemIDasURL = new URL((String)systemID);
        }
        catch (MalformedURLException e) {
            systemID = "file:" + (String)systemID;
            try {
                systemIDasURL = new URL((String)systemID);
            }
            catch (MalformedURLException e2) {
                throw e;
            }
        }
        this.currentReader = new StackedReader();
        this.readers = new ArrayDeque<StackedReader>();
        Reader reader = this.openStream(publicID, systemIDasURL.toString());
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
    }

    public StdXMLReader(Reader reader) {
        this.currentReader = new StackedReader();
        this.readers = new ArrayDeque<StackedReader>();
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        this.currentReader.publicId = "";
        try {
            this.currentReader.systemId = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public StdXMLReader(InputStream stream) throws IOException {
        PushbackInputStream pbstream = new PushbackInputStream(stream);
        StringBuilder charsRead = new StringBuilder();
        Reader reader = this.stream2reader(stream, charsRead);
        this.currentReader = new StackedReader();
        this.readers = new ArrayDeque<StackedReader>();
        this.currentReader.lineReader = new LineNumberReader(reader);
        this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        this.currentReader.publicId = "";
        try {
            this.currentReader.systemId = new URL("file:.");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.startNewStream(new StringReader(charsRead.toString()));
    }

    protected String getEncoding(String str) {
        if (!str.startsWith("<?xml")) {
            return null;
        }
        int index = 5;
        while (index < str.length()) {
            char delimiter;
            int index2;
            StringBuilder key = new StringBuilder();
            while (index < str.length() && str.charAt(index) <= ' ') {
                ++index;
            }
            while (index < str.length() && str.charAt(index) >= 'a' && str.charAt(index) <= 'z') {
                key.append(str.charAt(index));
                ++index;
            }
            while (index < str.length() && str.charAt(index) <= ' ') {
                ++index;
            }
            if (index >= str.length() || str.charAt(index) != '=') break;
            while (index < str.length() && str.charAt(index) != '\'' && str.charAt(index) != '\"') {
                ++index;
            }
            if (index >= str.length() || (index2 = str.indexOf(delimiter = str.charAt(index), ++index)) < 0) break;
            if (key.toString().equals("encoding")) {
                return str.substring(index, index2);
            }
            index = index2 + 1;
        }
        return null;
    }

    protected Reader stream2reader(InputStream stream, StringBuilder charsRead) throws IOException {
        PushbackInputStream pbstream = new PushbackInputStream(stream);
        int b = pbstream.read();
        switch (b) {
            case 0: 
            case 254: 
            case 255: {
                pbstream.unread(b);
                return new InputStreamReader((InputStream)pbstream, StandardCharsets.UTF_16);
            }
            case 239: {
                for (int i = 0; i < 2; ++i) {
                    if (pbstream.read() >= 0) continue;
                    throw new IOException("Unexpected end of file");
                }
                return new InputStreamReader((InputStream)pbstream, StandardCharsets.UTF_8);
            }
            case 60: {
                String encoding;
                b = pbstream.read();
                charsRead.append('<');
                while (b > 0 && b != 62) {
                    charsRead.append((char)b);
                    b = pbstream.read();
                }
                if (b > 0) {
                    charsRead.append((char)b);
                }
                if ((encoding = this.getEncoding(charsRead.toString())) == null) {
                    return new InputStreamReader((InputStream)pbstream, StandardCharsets.UTF_8);
                }
                charsRead.setLength(0);
                try {
                    return new InputStreamReader((InputStream)pbstream, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    return new InputStreamReader((InputStream)pbstream, StandardCharsets.UTF_8);
                }
            }
        }
        charsRead.append((char)b);
        return new InputStreamReader((InputStream)pbstream, StandardCharsets.UTF_8);
    }

    public char read() throws IOException {
        int ch = this.currentReader.pbReader.read();
        while (ch < 0) {
            if (this.readers.isEmpty()) {
                throw new IOException("Unexpected EOF");
            }
            this.currentReader.pbReader.close();
            this.currentReader = this.readers.pop();
            ch = this.currentReader.pbReader.read();
        }
        return (char)ch;
    }

    public boolean atEOF() throws IOException {
        int ch = this.currentReader.pbReader.read();
        while (ch < 0) {
            if (this.readers.isEmpty()) {
                return true;
            }
            this.currentReader.pbReader.close();
            this.currentReader = this.readers.pop();
            ch = this.currentReader.pbReader.read();
        }
        this.currentReader.pbReader.unread(ch);
        return false;
    }

    public void unread(char ch) throws IOException {
        this.currentReader.pbReader.unread(ch);
    }

    public Reader openStream(String publicID, String systemID) throws MalformedURLException, FileNotFoundException, IOException {
        URL url = new URL(this.currentReader.systemId, systemID);
        if (url.getRef() != null) {
            String ref = url.getRef();
            if (!url.getFile().isEmpty()) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
                url = new URL("jar:" + String.valueOf(url) + "!" + ref);
            } else {
                url = StdXMLReader.class.getResource(ref);
            }
        }
        this.currentReader.publicId = publicID;
        this.currentReader.systemId = url;
        StringBuilder charsRead = new StringBuilder();
        Reader reader = this.stream2reader(url.openStream(), charsRead);
        if (charsRead.length() == 0) {
            return reader;
        }
        String charsReadStr = charsRead.toString();
        PushbackReader pbreader = new PushbackReader(reader, charsReadStr.length());
        for (int i = charsReadStr.length() - 1; i >= 0; --i) {
            pbreader.unread(charsReadStr.charAt(i));
        }
        return pbreader;
    }

    public void startNewStream(Reader reader) {
        this.startNewStream(reader, false);
    }

    public void startNewStream(Reader reader, boolean isInternalEntity) {
        StackedReader oldReader = this.currentReader;
        this.readers.push(this.currentReader);
        this.currentReader = new StackedReader();
        if (isInternalEntity) {
            this.currentReader.lineReader = null;
            this.currentReader.pbReader = new PushbackReader(reader, 2);
        } else {
            this.currentReader.lineReader = new LineNumberReader(reader);
            this.currentReader.pbReader = new PushbackReader(this.currentReader.lineReader, 2);
        }
        this.currentReader.systemId = oldReader.systemId;
        this.currentReader.publicId = oldReader.publicId;
    }

    public int getStreamLevel() {
        return this.readers.size();
    }

    public int getLineNr() {
        if (this.currentReader.lineReader == null) {
            StackedReader sr = this.readers.peek();
            if (sr.lineReader == null) {
                return 0;
            }
            return sr.lineReader.getLineNumber() + 1;
        }
        return this.currentReader.lineReader.getLineNumber() + 1;
    }

    public String getSystemID() {
        return this.currentReader.systemId.toString();
    }

    public void setSystemID(String systemID) throws MalformedURLException {
        this.currentReader.systemId = new URL(this.currentReader.systemId, systemID);
    }

    public String getPublicID() {
        return this.currentReader.publicId;
    }

    public void setPublicID(String publicID) {
        this.currentReader.publicId = publicID;
    }

    public static StdXMLReader stringReader(String str) {
        return new StdXMLReader(new StringReader(str));
    }

    public static StdXMLReader fileReader(String filename) throws FileNotFoundException, IOException {
        StdXMLReader r = new StdXMLReader(new FileInputStream(filename));
        r.setSystemID(filename);
        for (StackedReader sr : r.readers) {
            sr.systemId = r.currentReader.systemId;
        }
        return r;
    }

    private static final class StackedReader {
        PushbackReader pbReader;
        LineNumberReader lineReader;
        URL systemId;
        String publicId;

        private StackedReader() {
        }
    }
}

