/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.AnsiStreamingLexer;
import com.intellij.execution.process.AnsiTerminalEmulator;
import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnsiEscapeDecoder {
    private final ColoredOutputTypeRegistry myColoredOutputTypeRegistry = ColoredOutputTypeRegistry.getInstance();
    private final AnsiStreamingLexer myStdoutLexer = new AnsiStreamingLexer();
    private final AnsiStreamingLexer myStderrLexer = new AnsiStreamingLexer();
    private final AnsiTerminalEmulator myStdoutEmulator = new AnsiTerminalEmulator();
    private final AnsiTerminalEmulator myStderrEmulator = new AnsiTerminalEmulator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escapeText(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        AnsiTerminalEmulator effectiveEmulator;
        AnsiStreamingLexer effectiveLexer;
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(1);
        }
        if (textAcceptor == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(2);
        }
        if (ProcessOutputType.isStdout((Key)outputType)) {
            effectiveLexer = this.myStdoutLexer;
            effectiveEmulator = this.myStdoutEmulator;
        } else if (ProcessOutputType.isStderr((Key)outputType)) {
            effectiveLexer = this.myStderrLexer;
            effectiveEmulator = this.myStderrEmulator;
        } else {
            this.processTextWithoutAnsi(text, outputType, textAcceptor);
            return;
        }
        List<Pair<String, Key>> chunks = null;
        AnsiStreamingLexer ansiStreamingLexer = effectiveLexer;
        synchronized (ansiStreamingLexer) {
            AnsiStreamingLexer.AnsiElementType elementType;
            effectiveLexer.append(text);
            effectiveLexer.advance();
            while ((elementType = effectiveLexer.getElementType()) != null) {
                String elementText = effectiveLexer.getElementTextSmart();
                assert (elementText != null);
                if (elementType == AnsiStreamingLexer.SGR) {
                    effectiveEmulator.processSgr(elementText);
                } else if (elementType == AnsiStreamingLexer.TEXT) {
                    chunks = this.processTextChunk(chunks, elementText, outputType, textAcceptor);
                } else assert (elementType == AnsiStreamingLexer.CONTROL);
                effectiveLexer.advance();
            }
        }
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    private void processTextWithoutAnsi(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        List<Pair<String, Key>> chunks;
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(4);
        }
        if (textAcceptor == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(5);
        }
        if ((chunks = this.processTextChunk(null, text, outputType, textAcceptor)) != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    @Nullable
    private List<Pair<String, Key>> processTextChunk(@Nullable List<Pair<String, Key>> buffer, @NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        if (text == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(6);
        }
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(7);
        }
        if (textAcceptor == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(8);
        }
        Key attributes = this.getCurrentOutputAttributes(outputType);
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            if (buffer == null) {
                buffer = new ArrayList<Pair<String, Key>>(1);
            }
            buffer.add((Pair<String, Key>)Pair.create((Object)text, (Object)attributes));
        } else {
            textAcceptor.coloredTextAvailable(text, attributes);
        }
        return buffer;
    }

    @NotNull
    protected Key getCurrentOutputAttributes(@NotNull Key outputType) {
        if (outputType == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(9);
        }
        if (ProcessOutputType.isStdout((Key)outputType)) {
            Object object = this.myStdoutEmulator.isInitialState() ? outputType : this.myColoredOutputTypeRegistry.getOutputType(this.myStdoutEmulator, outputType);
            if (object == null) {
                AnsiEscapeDecoder.$$$reportNull$$$0(10);
            }
            return object;
        }
        if (ProcessOutputType.isStderr((Key)outputType)) {
            Object object = this.myStderrEmulator.isInitialState() ? outputType : this.myColoredOutputTypeRegistry.getOutputType(this.myStderrEmulator, outputType);
            if (object == null) {
                AnsiEscapeDecoder.$$$reportNull$$$0(11);
            }
            return object;
        }
        Key key = outputType;
        if (key == null) {
            AnsiEscapeDecoder.$$$reportNull$$$0(12);
        }
        return key;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAcceptor";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/AnsiEscapeDecoder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/AnsiEscapeDecoder";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentOutputAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processTextWithoutAnsi";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTextChunk";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentOutputAttributes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(@NotNull String var1, @NotNull Key var2);
    }

    @Deprecated(forRemoval=true)
    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> var1);
    }
}

