/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.vcs.ui.ProgressStripeIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ProgressStripe
extends JBPanel {
    private final JComponent myTargetComponent;
    private final Disposable myDisposable;
    private final int myStartDelayMs;
    @NotNull
    private final JBPanel myPanel;
    protected DisposableLoadingDecorator myDecorator;

    public ProgressStripe(@NotNull JComponent targetComponent, @NotNull Disposable parent, int startDelayMs) {
        if (targetComponent == null) {
            ProgressStripe.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ProgressStripe.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myPanel = new JBPanel((LayoutManager)new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myPanel.add((Component)targetComponent);
        this.myTargetComponent = targetComponent;
        this.myDisposable = parent;
        this.myStartDelayMs = startDelayMs;
        this.createLoadingDecorator();
    }

    public ProgressStripe(@NotNull JComponent targetComponent, @NotNull Disposable parent) {
        if (targetComponent == null) {
            ProgressStripe.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            ProgressStripe.$$$reportNull$$$0(3);
        }
        this(targetComponent, parent, 300);
    }

    public void updateUI() {
        super.updateUI();
        if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
            this.createLoadingDecorator();
        }
    }

    private void createLoadingDecorator() {
        if (this.myDecorator != null) {
            this.remove(this.myDecorator.getComponent());
            Disposer.dispose((Disposable)this.myDecorator.getDisposable());
        }
        Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myDisposable, (Disposable)disposable);
        this.myDecorator = new DisposableLoadingDecorator(this.myTargetComponent, (JPanel)this.myPanel, disposable, this.myStartDelayMs);
        this.add(this.myDecorator.getComponent(), "Center");
        this.myDecorator.setLoadingText("");
    }

    public void startLoading() {
        this.myDecorator.startLoading(false);
    }

    public void startLoadingImmediately() {
        this.myDecorator.startLoadingImmediately();
    }

    public void stopLoading() {
        this.myDecorator.stopLoading();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "targetComponent";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/ui/ProgressStripe";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class DisposableLoadingDecorator
    extends LoadingDecorator {
        @NotNull
        private final Disposable myDisposable;

        DisposableLoadingDecorator(@NotNull JComponent component, @NotNull JPanel contentPanel, @NotNull Disposable disposable, int startDelayMs) {
            if (component == null) {
                DisposableLoadingDecorator.$$$reportNull$$$0(0);
            }
            if (contentPanel == null) {
                DisposableLoadingDecorator.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                DisposableLoadingDecorator.$$$reportNull$$$0(2);
            }
            super((JComponent)contentPanel, disposable, startDelayMs, false, ProgressStripeIcon.generateIcon(component));
            this.myDisposable = disposable;
        }

        public void startLoadingImmediately() {
            this.doStartLoading(false);
        }

        @NotNull
        protected NonOpaquePanel customizeLoadingLayer(JPanel parent, @NotNull JLabel text, @NotNull AnimatedIcon icon) {
            if (text == null) {
                DisposableLoadingDecorator.$$$reportNull$$$0(3);
            }
            if (icon == null) {
                DisposableLoadingDecorator.$$$reportNull$$$0(4);
            }
            parent.setLayout(new BorderLayout());
            NonOpaquePanel result2 = new NonOpaquePanel();
            result2.setLayout((LayoutManager)new BoxLayout((Container)result2, 1));
            result2.add((Component)icon);
            parent.add((Component)result2, "North");
            NonOpaquePanel nonOpaquePanel = result2;
            if (nonOpaquePanel == null) {
                DisposableLoadingDecorator.$$$reportNull$$$0(5);
            }
            return nonOpaquePanel;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myDisposable;
            if (disposable == null) {
                DisposableLoadingDecorator.$$$reportNull$$$0(6);
            }
            return disposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/ui/ProgressStripe$DisposableLoadingDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/ui/ProgressStripe$DisposableLoadingDecorator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "customizeLoadingLayer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeLoadingLayer";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

