/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllVcses
implements AllVcsesI,
Disposable {
    private static final Logger LOG = Logger.getInstance(AllVcses.class);
    private final Project myProject;
    private final Object myLock;
    private final Map<String, AbstractVcs> myVcses;
    private final Map<String, VcsEP> myExtensions;
    private final AtomicBoolean unbundledVcsNotificationShown;

    private AllVcses(@NotNull Project project) {
        if (project == null) {
            AllVcses.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myVcses = new HashMap<String, AbstractVcs>();
        this.myExtensions = new HashMap<String, VcsEP>();
        this.unbundledVcsNotificationShown = new AtomicBoolean();
        this.myProject = project;
        Iterator iterator = VcsEP.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext()) {
            VcsEP extension;
            String name = extension.name;
            extension = (VcsEP)iterator.next();
            VcsEP oldEp = this.myExtensions.put(name, extension);
            if (oldEp == null) continue;
            LOG.error(String.format("registering duplicated EP. name: %s, old: %s, new: %s", name, oldEp.vcsClass, extension.vcsClass));
        }
        VcsEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new MyExtensionPointListener(), (Disposable)project);
    }

    public static AllVcsesI getInstance(@NotNull Project project) {
        if (project == null) {
            AllVcses.$$$reportNull$$$0(1);
        }
        return (AllVcsesI)project.getService(AllVcsesI.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            String name = vcs.getName();
            if (this.myVcses.containsKey(name)) {
                LOG.error(String.format("vcs is already registered: %s", vcs), new Throwable());
                return;
            }
            if (this.myExtensions.containsKey(name)) {
                LOG.error(String.format("can't override vcs from EP. vcs: %s, ep: %s", vcs, this.myExtensions.get((Object)name).vcsClass), new Throwable());
                return;
            }
            this.myVcses.put(name, vcs);
        }
        AllVcses.registerVcs(vcs);
        ProjectLevelVcsManagerImpl.getInstanceImpl(this.myProject).updateMappedVcsesImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterManually(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            String name = vcs.getName();
            if (!this.myVcses.containsKey(name)) {
                LOG.error(String.format("vcs is not registered: %s", vcs), new Throwable());
                return;
            }
            this.myVcses.remove(name);
        }
        AllVcses.unregisterVcs(vcs);
        ProjectLevelVcsManagerImpl.getInstanceImpl(this.myProject).updateMappedVcsesImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVcs getByName(@Nullable String name) {
        VcsEP ep;
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs vcs = this.myVcses.get(name);
            if (vcs != null) {
                return vcs;
            }
            ep = this.myExtensions.get(name);
        }
        if (ep == null) {
            ObsoleteVcs obsoleteVcs = ObsoleteVcs.findByName(name);
            if (obsoleteVcs != null && this.unbundledVcsNotificationShown.compareAndSet(false, true)) {
                this.proposeToInstallPlugin(obsoleteVcs);
            }
            return null;
        }
        AbstractVcs vcs = ep.createVcs(this.myProject);
        LOG.assertTrue(name.equals(vcs.getName()), (Object)vcs);
        vcs.setupEnvironments();
        Object object2 = this.myLock;
        synchronized (object2) {
            if (this.myExtensions.get(name) != ep) {
                return null;
            }
            AbstractVcs oldVcs = this.myVcses.get(name);
            if (oldVcs != null) {
                return oldVcs;
            }
            this.myVcses.put(name, vcs);
        }
        AllVcses.registerVcs(vcs);
        return vcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        VcsEP ep;
        Object object = this.myLock;
        synchronized (object) {
            ep = this.myExtensions.get(name);
        }
        return ep == null ? null : ep.createDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<AbstractVcs> vcses;
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            vcses = new ArrayList<AbstractVcs>(this.myVcses.values());
            this.myVcses.clear();
        }
        for (AbstractVcs vcs : vcses) {
            AllVcses.unregisterVcs(vcs);
        }
    }

    private static void registerVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(4);
        }
        try {
            vcs.loadSettings();
            vcs.doStart();
            vcs.getProvidedStatuses();
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void unregisterVcs(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(5);
        }
        try {
            vcs.doShutdown();
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myExtensions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsDescriptor[] getAll() {
        ArrayList<VcsEP> eps;
        Object object = this.myLock;
        synchronized (object) {
            eps = new ArrayList<VcsEP>(this.myExtensions.values());
        }
        List result2 = ContainerUtil.sorted((Collection)ContainerUtil.map(eps, ep -> ep.createDescriptor()), Comparator.comparing(VcsDescriptor::getName, String::compareTo));
        return result2.toArray(new VcsDescriptor[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVcs[] getSupportedVcses() {
        ArrayList<String> names;
        Object object = this.myLock;
        synchronized (object) {
            names = new ArrayList<String>(this.myExtensions.keySet());
        }
        names.sort(String::compareTo);
        return ContainerUtil.mapNotNull(names, this::getByName).toArray(new AbstractVcs[0]);
    }

    private void proposeToInstallPlugin(@NotNull ObsoleteVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(6);
        }
        String message = VcsBundle.message((String)"impl.notification.content.plugin.was.unbundled.needs.to.be.installed.manually", (Object[])new Object[]{vcs});
        Notification notification = VcsNotifier.importantNotification().createNotification(message, NotificationType.WARNING).setDisplayId("vcs.obsolete.plugin.unbundled").addAction((AnAction)NotificationAction.createSimpleExpiring((String)VcsBundle.message((String)"action.NotificationAction.AllVcses.text.install", (Object[])new Object[0]), () -> this.installPlugin(vcs))).addAction((AnAction)NotificationAction.createSimple((String)VcsBundle.message((String)"action.NotificationAction.AllVcses.text.read.more", (Object[])new Object[0]), () -> BrowserUtil.browse((String)"https://blog.jetbrains.com/idea/2019/02/unbundling-tfs-and-cvs-integration-plugins/")));
        VcsNotifier.getInstance(this.myProject).notify(notification);
    }

    private void installPlugin(final @NotNull ObsoleteVcs vcs) {
        if (vcs == null) {
            AllVcses.$$$reportNull$$$0(7);
        }
        new Task.Backgroundable(this.myProject, VcsBundle.message((String)"impl.progress.title.installing.plugin", (Object[])new Object[0])){

            @RequiresBackgroundThread
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    PluginNode descriptor = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdate(vcs.pluginId, null, indicator);
                    if (descriptor != null) {
                        PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor);
                        if (downloader.prepareToInstall(indicator)) {
                            downloader.install();
                            PluginEnabler.HEADLESS.enable(List.of(descriptor));
                            PluginManagerMain.notifyPluginsUpdated((Project)this.myProject);
                        }
                    } else {
                        this.showErrorNotification(vcs, VcsBundle.message((String)"impl.notification.content.could.not.find.plugin", (Object[])new Object[]{vcs.pluginId}));
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    this.showErrorNotification(vcs, e.getMessage());
                }
            }

            private void showErrorNotification(@NotNull ObsoleteVcs vcs2, @NlsContexts.NotificationContent @NotNull String message) {
                if (vcs2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(2);
                }
                String title = VcsBundle.message((String)"impl.notification.title.failed.to.install.plugin", (Object[])new Object[0]);
                Notification notification = VcsNotifier.importantNotification().createNotification(title, message, NotificationType.ERROR).setDisplayId("vcs.suggested.plugin.install.failed").addAction((AnAction)NotificationAction.createSimple((Supplier)VcsBundle.messagePointer((String)"action.NotificationAction.AllVcses.text.open.plugin.page", (Object[])new Object[0]), () -> BrowserUtil.browse((String)vcs2.pluginUrl)));
                VcsNotifier.getInstance(this.myProject).notify(notification);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "vcs";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showErrorNotification";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerManually";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterManually";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerVcs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterVcs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "proposeToInstallPlugin";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "installPlugin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyExtensionPointListener
    implements ExtensionPointListener<VcsEP> {
        private MyExtensionPointListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void extensionAdded(@NotNull VcsEP extension, @NotNull PluginDescriptor pluginDescriptor) {
            AbstractVcs oldVcs;
            if (extension == null) {
                MyExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(1);
            }
            Object object = AllVcses.this.myLock;
            synchronized (object) {
                String name = extension.name;
                VcsEP oldEp = AllVcses.this.myExtensions.put(name, extension);
                if (oldEp != null) {
                    LOG.error(String.format("registering duplicated EP. name: %s, old: %s, new: %s", name, oldEp.vcsClass, extension.vcsClass));
                }
                if ((oldVcs = AllVcses.this.myVcses.remove(name)) != null) {
                    LOG.error(String.format("overriding VCS with EP. name: %s, old: %s, new: %s", name, oldVcs.getClass(), extension.vcsClass));
                }
            }
            if (oldVcs != null) {
                AllVcses.unregisterVcs(oldVcs);
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl(AllVcses.this.myProject).updateMappedVcsesImmediately();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void extensionRemoved(@NotNull VcsEP extension, @NotNull PluginDescriptor pluginDescriptor) {
            AbstractVcs oldVcs;
            if (extension == null) {
                MyExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                MyExtensionPointListener.$$$reportNull$$$0(3);
            }
            Object object = AllVcses.this.myLock;
            synchronized (object) {
                boolean wasRemoved;
                String name = extension.name;
                oldVcs = AllVcses.this.myVcses.get(name);
                if (oldVcs != null) {
                    AllVcses.this.myVcses.remove(name);
                }
                if (!(wasRemoved = AllVcses.this.myExtensions.remove(name, extension))) {
                    LOG.error(String.format("removing unregistered EP. name: %s, ep: %s", name, extension.vcsClass));
                }
            }
            if (oldVcs != null) {
                AllVcses.unregisterVcs(oldVcs);
            }
            ProjectLevelVcsManagerImpl.getInstanceImpl(AllVcses.this.myProject).updateMappedVcsesImmediately();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses$MyExtensionPointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ObsoleteVcs {
        CVS("CVS", "CVS", "https://plugins.jetbrains.com/plugin/10746-cvs-integration"),
        TFS("TFS", "TFS", "https://plugins.jetbrains.com/plugin/4578-tfs");

        @NotNull
        private final String vcsName;
        @NotNull
        private final PluginId pluginId;
        @NotNull
        private final String pluginUrl;

        private ObsoleteVcs(@NotNull String vcsName, String pluginId, String pluginUrl) {
            if (vcsName == null) {
                ObsoleteVcs.$$$reportNull$$$0(0);
            }
            if (pluginId == null) {
                ObsoleteVcs.$$$reportNull$$$0(1);
            }
            if (pluginUrl == null) {
                ObsoleteVcs.$$$reportNull$$$0(2);
            }
            this.vcsName = vcsName;
            this.pluginId = PluginId.getId((String)pluginId);
            this.pluginUrl = pluginUrl;
        }

        @Nullable
        public static ObsoleteVcs findByName(@NotNull String name) {
            if (name == null) {
                ObsoleteVcs.$$$reportNull$$$0(3);
            }
            return (ObsoleteVcs)((Object)ContainerUtil.find((Object[])ObsoleteVcs.values(), vcs -> vcs.vcsName.equals(name)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginUrl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/AllVcses$ObsoleteVcs";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findByName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

