/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.backend;

import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.platform.recentFiles.backend.StopOnTwoSameNamesProcessor;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import com.intellij.platform.recentFiles.shared.SwitcherRpcDto;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.Color;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0001\u001a/\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\b\u0010\u000e\u001a\u0004\u0018\u0001H\nH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0015"}, d2={"getFilesToShow", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "recentFileKind", "Lcom/intellij/platform/recentFiles/shared/RecentFileKind;", "filesFromFrontendEditorSelectionHistory", "addIfNotNull", "", "T", "", "targetCollection", "", "item", "(Ljava/util/Collection;Ljava/lang/Object;)Z", "getRecentFiles", "areThereFilesWithSameName", "virtualFile", "createRecentFileViewModel", "Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;", "intellij.platform.recentFiles.backend"})
@SourceDebugExtension(value={"SMAP\nbackendRecentFilesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 backendRecentFilesCollector.kt\ncom/intellij/platform/recentFiles/backend/BackendRecentFilesCollectorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n774#2:190\n865#2,2:191\n3829#3:193\n4344#3,2:194\n1#4:196\n*S KotlinDebug\n*F\n+ 1 backendRecentFilesCollector.kt\ncom/intellij/platform/recentFiles/backend/BackendRecentFilesCollectorKt\n*L\n69#1:190\n69#1:191,2\n118#1:193\n118#1:194,2\n*E\n"})
public final class BackendRecentFilesCollectorKt {
    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public static final List<VirtualFile> getFilesToShow(@NotNull Project project, @NotNull RecentFileKind recentFileKind, @NotNull List<? extends VirtualFile> filesFromFrontendEditorSelectionHistory) {
        List list;
        boolean unpinned;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recentFileKind, (String)"recentFileKind");
        Intrinsics.checkNotNullParameter(filesFromFrontendEditorSelectionHistory, (String)"filesFromFrontendEditorSelectionHistory");
        ArrayList<Object> filesData = new ArrayList<Object>();
        ArrayList<VirtualFile> editors = new ArrayList<VirtualFile>();
        LinkedHashSet addedFiles = new LinkedHashSet();
        boolean bl = unpinned = recentFileKind == RecentFileKind.RECENTLY_OPENED_UNPINNED;
        if (unpinned) {
            for (VirtualFile virtualFile : filesFromFrontendEditorSelectionHistory) {
                editors.add(virtualFile);
            }
            Iterator iterator = editors.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Object> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                VirtualFile virtualFile = (VirtualFile)object;
                BackendRecentFilesCollectorKt.addIfNotNull(addedFiles, virtualFile);
                filesData.add(virtualFile);
                if (filesData.size() < 30) continue;
            }
        }
        if (filesData.size() > 1) {
            return filesData;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[recentFileKind.ordinal()]) {
            case 1: {
                List list2 = IdeDocumentHistory.getInstance((Project)project).getChangedFiles();
                list = list2;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChangedFiles(...)");
                break;
            }
            case 2: 
            case 3: {
                list = BackendRecentFilesCollectorKt.getRecentFiles(project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List filesForInit = list;
        if (!filesForInit.isEmpty()) {
            int i;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            int n = SequencesKt.count((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)editors)));
            int maxFiles = Math.max(n, filesForInit.size());
            Iterable iterable = ToolWindowManagerEx.Companion.getInstanceEx(project).getToolWindows();
            boolean $i$f$filter = false;
            void var13_16 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ToolWindow it = (ToolWindow)element$iv$iv;
                boolean bl2 = false;
                if (!(it.isAvailable() && it.isShowStripeButton())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int activeToolWindowsLimit = ((List)destination$iv$iv).size();
            int minIndex = unpinned ? filesForInit.size() - RangesKt.coerceAtMost((int)activeToolWindowsLimit, (int)maxFiles) : 0;
            if (minIndex <= (i = filesForInit.size() - 1)) {
                while (true) {
                    VirtualFile info = (VirtualFile)filesForInit.get(i);
                    boolean add = true;
                    if (!unpinned) {
                        Iterator iterator;
                        Intrinsics.checkNotNullExpressionValue(filesData.iterator(), (String)"iterator(...)");
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                            VirtualFile fileInfo = (VirtualFile)e;
                            if (!Intrinsics.areEqual((Object)fileInfo, (Object)info)) continue;
                            add = false;
                            break;
                        }
                    }
                    if (add && BackendRecentFilesCollectorKt.addIfNotNull(addedFiles, info)) {
                        filesData.add(info);
                    }
                    if (i == minIndex) break;
                    --i;
                }
            }
        }
        if (editors.size() == 1 && (filesData.isEmpty() || !Intrinsics.areEqual(editors.get(0), filesData.get(0))) && BackendRecentFilesCollectorKt.addIfNotNull(addedFiles, editors.get(0))) {
            filesData.add(0, editors.get(0));
        }
        return filesData;
    }

    private static final <T> boolean addIfNotNull(Collection<T> targetCollection, T item) {
        if (item == null) {
            return false;
        }
        return targetCollection.add(item);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getRecentFiles(Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List recentFiles = EditorHistoryManager.Companion.getInstance(project).getFileList();
        Object[] objectArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenFiles(...)");
        Object[] openFiles = objectArray;
        HashSet recentFilesSet = new HashSet(recentFiles);
        HashSet openFilesSet = ArraysKt.toHashSet((Object[])openFiles);
        int index = 0;
        int n = ((Collection)recentFiles).size();
        for (int i = 0; i < n; ++i) {
            if (!openFilesSet.contains(recentFiles.get(i))) continue;
            index = i;
            break;
        }
        ArrayList result = new ArrayList(recentFiles);
        Object[] objectArray2 = openFiles;
        int n2 = index;
        ArrayList arrayList = result;
        boolean $i$f$filter = false;
        void var9_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n3 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n3; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!recentFilesSet.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        arrayList.addAll(n2, list);
        return result;
    }

    private static final boolean areThereFilesWithSameName(VirtualFile virtualFile, Project project) {
        boolean bl;
        if (PlatformUtils.isRider()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            GlobalSearchScope searchScope = globalSearchScope;
            String string = virtualFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            StopOnTwoSameNamesProcessor processor = new StopOnTwoSameNamesProcessor(string);
            FilenameIndex.processFilesByName((String)virtualFile.getName(), (boolean)false, (GlobalSearchScope)searchScope, (Processor)processor);
            bl = processor.areThereMoreThanOneFile();
        } else {
            bl = FilenameIndex.getVirtualFilesByName((String)virtualFile.getName(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)).size() > 1;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final SwitcherRpcDto.File createRecentFileViewModel(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        block9: {
            block10: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    ProgressManager.checkCanceled();
                    v0 /* !! */  = virtualFile.getParent();
                    v1 = v0 /* !! */  != null && (v0 /* !! */  = v0 /* !! */ .getPath()) != null ? NioPathUtil.toNioPathOrNull((String)v0 /* !! */ ) : (parentPath = null);
                    if (parentPath != null && parentPath.getNameCount() != 0 && BackendRecentFilesCollectorKt.areThereFilesWithSameName(virtualFile, project)) break block8;
                    v2 = "";
                    break block9;
                }
                filePath = parentPath.toString();
                v3 = project.getBasePath();
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-BackendRecentFilesCollectorKt$createRecentFileViewModel$result$projectPath$1 = false;
                    v4 = FileUtil.toSystemDependentName((String)it);
                } else {
                    v4 = projectPath = null;
                }
                if (projectPath == null || !FileUtil.isAncestor((String)projectPath, (String)filePath, (boolean)true)) break block10;
                locationRelativeToProjectDir = FileUtil.getRelativePath((String)projectPath, (String)filePath, (char)File.separatorChar);
                if (locationRelativeToProjectDir == null) ** GOTO lbl-1000
                v5 = Paths.get(locationRelativeToProjectDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"get(...)");
                if (v5.getNameCount() != 0) {
                    v2 = locationRelativeToProjectDir;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = filePath;
                }
                break block9;
            }
            if (FileUtil.isAncestor((String)SystemProperties.getUserHome(), (String)filePath, (boolean)true)) {
                locationRelativeToUserHome = FileUtil.getLocationRelativeToUserHome((String)filePath);
                Intrinsics.checkNotNull((Object)locationRelativeToUserHome);
                v6 = Paths.get(locationRelativeToUserHome, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"get(...)");
                v2 = v6.getNameCount() != 0 ? locationRelativeToUserHome : filePath;
            } else {
                v2 = filePath;
            }
        }
        result = v2;
        ProgressManager.checkCanceled();
        v7 = EditorTabPresentationUtil.getCustomEditorTabTitle((Project)project, (VirtualFile)virtualFile);
        if (v7 == null) {
            v8 = virtualFile.getPresentableName();
            v7 = v8;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getPresentableName(...)");
        }
        var4_3 = v7;
        v9 /* !! */  = virtualFile.getParent();
        if (v9 /* !! */  == null || (v9 /* !! */  = v9 /* !! */ .getPresentableUrl()) == null) {
            v10 = virtualFile.getPresentableUrl();
            v9 /* !! */  = v10;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getPresentableUrl(...)");
        }
        v11 = FileUtil.getLocationRelativeToUserHome((String)v9 /* !! */ );
        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getLocationRelativeToUserHome(...)");
        var5_7 = v11;
        Intrinsics.checkNotNull((Object)result);
        var6_8 = result;
        var7_10 = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
        var8_4 = VirtualFileIdKt.rpcId((VirtualFile)virtualFile);
        var9_6 = IconIdKt.rpcId((Icon)IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)project));
        v12 = VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)virtualFile);
        var10_11 = v12 != null ? ColorIdKt.rpcId((Color)v12) : null;
        v13 = FileStatusManager.getInstance((Project)project).getStatus(virtualFile).getColor();
        var11_12 = v13 != null ? ColorIdKt.rpcId((Color)v13) : null;
        return new SwitcherRpcDto.File(var4_3, var5_7, var6_8, var7_10, var9_6, var11_12, var10_11, var8_4);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecentFileKind.values().length];
            try {
                nArray[RecentFileKind.RECENTLY_EDITED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_OPENED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_OPENED_UNPINNED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

