/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.Paths;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Difference {
    private final boolean myIsFile;
    private final Entry myLeft;
    private final Entry myRight;
    private final boolean myRightContentCurrent;

    public Difference(boolean isFile, Entry left, Entry right) {
        this(isFile, left, right, false);
    }

    public Difference(@Nullable Entry left, @Nullable Entry right, boolean isRightContentCurrent) {
        this(Difference.isFile(left, right), left, right, isRightContentCurrent);
    }

    public Difference(boolean isFile, @Nullable Entry left, @Nullable Entry right, boolean isRightContentCurrent) {
        this.myIsFile = isFile;
        this.myLeft = left;
        this.myRight = right;
        this.myRightContentCurrent = isRightContentCurrent;
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    @Nullable
    public Entry getLeft() {
        return this.myLeft;
    }

    @Nullable
    public Entry getRight() {
        return this.myRight;
    }

    @Nullable
    public FilePath getFilePath() {
        if (this.myRight != null) {
            return Difference.getFilePath(this.myRight);
        }
        if (this.myLeft != null) {
            return Difference.getFilePath(this.myLeft);
        }
        return null;
    }

    public ContentRevision getLeftContentRevision(IdeaGateway gw) {
        return Difference.createContentRevision(this.getLeft(), gw);
    }

    public ContentRevision getRightContentRevision(IdeaGateway gw) {
        VirtualFile file;
        Entry entry = this.getRight();
        if (this.myRightContentCurrent && entry != null && (file = gw.findVirtualFile(entry.getPath())) != null) {
            return new CurrentContentRevision(Paths.createDvcsFilePath(file));
        }
        return Difference.createContentRevision(entry, gw);
    }

    private static ContentRevision createContentRevision(final @Nullable Entry e, final IdeaGateway gw) {
        if (e == null) {
            return null;
        }
        return new ByteBackedContentRevision(){

            @Nullable
            public String getContent() {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getString(e, gw);
            }

            public byte @Nullable [] getContentAsBytes() {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getBytes();
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = Difference.getFilePath(e);
                if (filePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return filePath;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
                if (vcsRevisionNumber == null) {
                    1.$$$reportNull$$$0(1);
                }
                return vcsRevisionNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/history/core/revisions/Difference$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionNumber";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static FilePath getFilePath(@NotNull Entry entry) {
        if (entry == null) {
            Difference.$$$reportNull$$$0(0);
        }
        FilePath filePath = Paths.createDvcsFilePath(entry.getPath(), entry.isDirectory());
        if (filePath == null) {
            Difference.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    private static boolean isFile(@Nullable Entry left, @Nullable Entry right) {
        if (left != null) {
            return !left.isDirectory();
        }
        if (right != null) {
            return !right.isDirectory();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/core/revisions/Difference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/core/revisions/Difference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

