/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class JVMDebuggerEvaluatorTest
extends LightPlatformCodeInsightTestCase {
    protected static ExpectedExpression noExpressions() {
        return new ExpectedExpression(null, true);
    }

    protected static ExpectedExpression expressionWithoutSideEffects(@NotNull String expr) {
        if (expr == null) {
            JVMDebuggerEvaluatorTest.$$$reportNull$$$0(0);
        }
        return new ExpectedExpression(expr, false);
    }

    protected static ExpectedExpression expressionWithSideEffects(@NotNull String expr) {
        if (expr == null) {
            JVMDebuggerEvaluatorTest.$$$reportNull$$$0(1);
        }
        return new ExpectedExpression(expr, true);
    }

    protected void checkExpressionRangeAtCaret(ExpectedExpression expected) {
        Editor editor2 = this.getEditor();
        Document document = editor2.getDocument();
        int caretOffset = editor2.getCaretModel().getOffset();
        JavaDebuggerEvaluator evaluator = new JavaDebuggerEvaluator(null, null);
        if (expected.expression == null) {
            this.checkExpressionRangeImpl(null, false, evaluator, document, caretOffset);
            this.checkExpressionRangeImpl(null, true, evaluator, document, caretOffset);
        } else if (expected.sideEffects) {
            this.checkExpressionRangeImpl(null, false, evaluator, document, caretOffset);
            this.checkExpressionRangeImpl(expected.expression, true, evaluator, document, caretOffset);
        } else {
            this.checkExpressionRangeImpl(expected.expression, false, evaluator, document, caretOffset);
            this.checkExpressionRangeImpl(expected.expression, true, evaluator, document, caretOffset);
        }
    }

    private void checkExpressionRangeImpl(String expectedExpression, boolean sideEffectsAllowed, JavaDebuggerEvaluator evaluator, Document document, int caretOffset) {
        Promise infoAsync = evaluator.getExpressionInfoAtOffsetAsync(this.getProject(), document, caretOffset, sideEffectsAllowed);
        try {
            ExpressionInfo info = (ExpressionInfo)infoAsync.blockingGet(25000);
            if (info != null) {
                JVMDebuggerEvaluatorTest.assertEquals((String)("Text do not match (sideEffectsAllowed = " + sideEffectsAllowed + ")"), (String)expectedExpression, (String)document.getText(info.getTextRange()));
            } else if (expectedExpression != null) {
                JVMDebuggerEvaluatorTest.fail((String)("Expected " + expectedExpression + ", but was null (sideEffectsAllowed = " + sideEffectsAllowed + ")"));
            }
        }
        catch (Exception e) {
            JVMDebuggerEvaluatorTest.fail((String)"Timeout while getting ExpressionInfo");
        }
    }

    protected EvaluationMode getEvalModeForSelection() {
        SelectionModel selection = this.getEditor().getSelectionModel();
        String code = selection.getSelectedText();
        JVMDebuggerEvaluatorTest.assertNotNull((String)"Expected some selection", (Object)code);
        int start = selection.getSelectionStart();
        int end = selection.getSelectionEnd();
        JavaDebuggerEvaluator evaluator = new JavaDebuggerEvaluator(null, null);
        return evaluator.getEvaluationMode(code, start, end, this.getFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expr";
        objectArray2[1] = "com/intellij/debugger/ui/JVMDebuggerEvaluatorTest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionWithoutSideEffects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionWithSideEffects";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static final class ExpectedExpression {
        @Nullable
        final String expression;
        final boolean sideEffects;

        private ExpectedExpression(@Nullable String expression, boolean sideEffects) {
            this.expression = expression;
            this.sideEffects = sideEffects;
        }
    }
}

