/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import org.jacoco.core.analysis.CoverageNodeImpl;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceNode;
import org.jacoco.core.internal.analysis.CounterImpl;
import org.jacoco.core.internal.analysis.LineImpl;

public class SourceNodeImpl
extends CoverageNodeImpl
implements ISourceNode {
    private LineImpl[] lines = null;
    private int offset = -1;

    public SourceNodeImpl(ICoverageNode.ElementType elementType, String name) {
        super(elementType, name);
    }

    public boolean applyFragment(SourceNodeImpl fragment) {
        boolean applied = false;
        for (int line = this.getFirstLine(); line <= this.getLastLine(); ++line) {
            LineImpl fragmentLine = fragment.getLine(line);
            if (((Object)fragmentLine).equals(LineImpl.EMPTY)) continue;
            LineImpl l = this.getLine(line);
            CounterImpl counter = l.getInstructionCounter().getCoveredCount() > 0 || fragmentLine.getInstructionCounter().getCoveredCount() > 0 ? CounterImpl.COUNTER_0_1 : CounterImpl.COUNTER_1_0;
            this.lines[line - this.offset] = LineImpl.EMPTY;
            if (l.instructions.covered > 0) {
                this.lineCounter = this.lineCounter.increment(0, -1);
            } else if (l.instructions.missed > 0) {
                this.lineCounter = this.lineCounter.increment(-1, 0);
            }
            this.incrementLine(counter, CounterImpl.COUNTER_0_0, line);
            this.instructionCounter = this.instructionCounter.increment(counter.missed - l.instructions.missed, counter.covered - l.instructions.covered);
            this.branchCounter = this.branchCounter.increment(-l.branches.missed, -l.branches.covered);
            applied = true;
        }
        return applied;
    }

    public void ensureCapacity(int first, int last) {
        if (first == -1 || last == -1) {
            return;
        }
        if (this.lines == null) {
            this.offset = first;
            this.lines = new LineImpl[last - first + 1];
        } else {
            int newFirst = Math.min(this.getFirstLine(), first);
            int newLast = Math.max(this.getLastLine(), last);
            int newLength = newLast - newFirst + 1;
            if (newLength > this.lines.length) {
                LineImpl[] newLines = new LineImpl[newLength];
                System.arraycopy(this.lines, 0, newLines, this.offset - newFirst, this.lines.length);
                this.offset = newFirst;
                this.lines = newLines;
            }
        }
    }

    public void increment(ISourceNode child) {
        this.instructionCounter = this.instructionCounter.increment(child.getInstructionCounter());
        this.branchCounter = this.branchCounter.increment(child.getBranchCounter());
        this.complexityCounter = this.complexityCounter.increment(child.getComplexityCounter());
        this.methodCounter = this.methodCounter.increment(child.getMethodCounter());
        this.classCounter = this.classCounter.increment(child.getClassCounter());
        int firstLine = child.getFirstLine();
        if (firstLine != -1) {
            int lastLine = child.getLastLine();
            this.ensureCapacity(firstLine, lastLine);
            for (int i = firstLine; i <= lastLine; ++i) {
                ILine line = child.getLine(i);
                this.incrementLine(line.getInstructionCounter(), line.getBranchCounter(), i);
            }
        }
    }

    public void increment(ICounter instructions, ICounter branches, int line) {
        if (line != -1) {
            this.incrementLine(instructions, branches, line);
        }
        this.instructionCounter = this.instructionCounter.increment(instructions);
        this.branchCounter = this.branchCounter.increment(branches);
    }

    private void incrementLine(ICounter instructions, ICounter branches, int line) {
        this.ensureCapacity(line, line);
        LineImpl l = this.getLine(line);
        int oldTotal = l.getInstructionCounter().getTotalCount();
        int oldCovered = l.getInstructionCounter().getCoveredCount();
        this.lines[line - this.offset] = l.increment(instructions, branches);
        if (instructions.getTotalCount() > 0) {
            if (instructions.getCoveredCount() == 0) {
                if (oldTotal == 0) {
                    this.lineCounter = this.lineCounter.increment(CounterImpl.COUNTER_1_0);
                }
            } else if (oldTotal == 0) {
                this.lineCounter = this.lineCounter.increment(CounterImpl.COUNTER_0_1);
            } else if (oldCovered == 0) {
                this.lineCounter = this.lineCounter.increment(-1, 1);
            }
        }
    }

    public int getFirstLine() {
        return this.offset;
    }

    public int getLastLine() {
        return this.lines == null ? -1 : this.offset + this.lines.length - 1;
    }

    public LineImpl getLine(int nr) {
        if (this.lines == null || nr < this.getFirstLine() || nr > this.getLastLine()) {
            return LineImpl.EMPTY;
        }
        LineImpl line = this.lines[nr - this.offset];
        return line == null ? LineImpl.EMPTY : line;
    }
}

