/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.security.ssl;

import java.security.cert.CertificateException;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

class Multiplexor {
    private final ConcurrentHashMap<Integer, CompletableFuture<String>> requests = new ConcurrentHashMap();
    private final Thread reader = new Thread(this::read, "Maven Server Delegating SSL Reader");
    private final AtomicInteger counter = new AtomicInteger(1);
    private final Scanner myScanner = new Scanner(System.in);

    Multiplexor() {
    }

    private void read() {
        while (this.myScanner.hasNextLine()) {
            this.readNextResponse();
        }
    }

    private void readNextResponse() {
        String line = this.myScanner.nextLine();
        if (!"----------IdeDelegateTrustManager----------".equals(line)) {
            return;
        }
        line = this.myScanner.nextLine();
        if (!"----------RESPONSE----------".equals(line)) {
            return;
        }
        line = this.myScanner.nextLine();
        try {
            CompletableFuture<String> future;
            Integer key = Integer.parseInt(line);
            line = this.myScanner.nextLine();
            if (line.equals("----------ERROR----------")) {
                CompletableFuture<String> future2 = this.requests.get(key);
                if (future2 != null) {
                    future2.completeExceptionally(new CertificateException());
                }
            } else if (line.equals("----------OK----------") && (future = this.requests.get(key)) != null) {
                future.complete("ok");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void start() {
        this.reader.setDaemon(true);
        this.reader.start();
    }

    void waitForResponse(Integer key) throws CertificateException {
        try {
            this.requests.get(key).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    Integer getKey() {
        Integer key = this.counter.getAndIncrement();
        this.requests.put(key, new CompletableFuture());
        return key;
    }
}

