/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.local.ActionExtendedSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.keymap.KeymapUtil;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.DocumentationSuggestion;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.TipSuggestion;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.statistics.FeatureSuggesterStatistics;
import training.featuresSuggester.suggesters.FeatureSuggester;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0004J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0004J\b\u0010\u0018\u001a\u00020\u0013H\u0004J\b\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0017R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0012\u0010\f\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u001c"}, d2={"Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "Ltraining/featuresSuggester/suggesters/FeatureSuggester;", "<init>", "()V", "suggestingTipId", "", "getSuggestingTipId", "()Ljava/lang/String;", "suggestingDocUrl", "getSuggestingDocUrl", "message", "getMessage", "suggestingActionId", "getSuggestingActionId", "isSuggestionNeeded", "", "logStatisticsThatSuggestionIsFound", "", "suggestion", "Ltraining/featuresSuggester/Suggestion;", "isSuggestingActionUsedRecently", "actionSummary", "Lcom/intellij/internal/statistic/local/ActionExtendedSummary;", "isSuggestionShownRecently", "createSuggestion", "isRedoOrUndoRunning", "getShortcutText", "actionId", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nAbstractFeatureSuggester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFeatureSuggester.kt\ntraining/featuresSuggester/suggesters/AbstractFeatureSuggester\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,78:1\n1#2:79\n40#3,3:80\n*S KotlinDebug\n*F\n+ 1 AbstractFeatureSuggester.kt\ntraining/featuresSuggester/suggesters/AbstractFeatureSuggester\n*L\n41#1:80,3\n*E\n"})
public abstract class AbstractFeatureSuggester
implements FeatureSuggester {
    @Nullable
    private final String suggestingTipId;
    @Nullable
    private final String suggestingDocUrl;

    @Nullable
    protected String getSuggestingTipId() {
        return this.suggestingTipId;
    }

    @Nullable
    protected String getSuggestingDocUrl() {
        return this.suggestingDocUrl;
    }

    @NotNull
    protected abstract String getMessage();

    @NotNull
    protected abstract String getSuggestingActionId();

    @Override
    public boolean isSuggestionNeeded() {
        return !this.isSuggestingActionUsedRecently() && !this.isSuggestionShownRecently();
    }

    @Override
    public void logStatisticsThatSuggestionIsFound(@NotNull Suggestion suggestion) {
        long l;
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        ActionExtendedSummary actionExtendedSummary = this.actionSummary();
        if (actionExtendedSummary != null) {
            long it = actionExtendedSummary.lastUsedTimestamp;
            boolean bl = false;
            l = (System.currentTimeMillis() - it) / TimeUnit.DAYS.toMillis(1L);
        } else {
            l = -1L;
        }
        long daysPassedFromLastUsage = l;
        FeatureSuggesterStatistics.INSTANCE.logSuggestionFound(this.getId(), !this.isSuggestingActionUsedRecently(), (int)daysPassedFromLastUsage);
    }

    protected final boolean isSuggestingActionUsedRecently() {
        ActionExtendedSummary actionExtendedSummary = this.actionSummary();
        if (actionExtendedSummary == null) {
            return false;
        }
        ActionExtendedSummary summary = actionExtendedSummary;
        long lastTimeUsed = summary.lastUsedTimestamp;
        long oldestWorkingDayStart = FeatureSuggesterSettings.Companion.instance().getOldestWorkingDayStartMillis(this.getMinSuggestingIntervalDays());
        return lastTimeUsed > oldestWorkingDayStart;
    }

    private final ActionExtendedSummary actionSummary() {
        boolean $i$f$service = false;
        Class<ActionsLocalSummary> serviceClass$iv = ActionsLocalSummary.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((ActionsLocalSummary)object).getActionStatsById(this.getSuggestingActionId());
    }

    protected final boolean isSuggestionShownRecently() {
        long lastTimeShown = FeatureSuggesterSettings.Companion.instance().getSuggestionLastShownTime(this.getId());
        long delta = System.currentTimeMillis() - lastTimeShown;
        return delta < TimeUnit.DAYS.toMillis(1L);
    }

    @NotNull
    protected final Suggestion createSuggestion() {
        Suggestion suggestion;
        if (this.isRedoOrUndoRunning()) {
            return NoSuggestion.INSTANCE;
        }
        String fullMessage = this.getMessage() + " " + this.getShortcutText(this.getSuggestingActionId());
        if (this.getSuggestingTipId() != null) {
            String string = this.getId();
            String string2 = this.getSuggestingTipId();
            Intrinsics.checkNotNull((Object)string2);
            suggestion = new TipSuggestion(fullMessage, string, string2);
        } else if (this.getSuggestingDocUrl() != null) {
            String string = this.getId();
            String string3 = this.getSuggestingDocUrl();
            Intrinsics.checkNotNull((Object)string3);
            suggestion = new DocumentationSuggestion(fullMessage, string, string3);
        } else {
            throw new IllegalStateException("Suggester must implement 'suggestingTipFileName' or 'suggestingDocLink' property.".toString());
        }
        return suggestion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRedoOrUndoRunning() {
        String commandName = CommandProcessor.getInstance().getCurrentCommandName();
        if (commandName == null) return false;
        Object[] objectArray = new Object[]{""};
        String string = ActionsBundle.message((String)"action.redo.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        if (StringsKt.startsWith$default((String)commandName, (String)string, (boolean)false, (int)2, null)) return true;
        objectArray = new Object[]{""};
        String string2 = ActionsBundle.message((String)"action.undo.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        if (!StringsKt.startsWith$default((String)commandName, (String)string2, (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nls
    @NotNull
    public String getShortcutText(@NotNull String actionId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        String string2 = KeymapUtil.getShortcutText((String)actionId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutText(...)");
        String shortcut = string2;
        if (Intrinsics.areEqual((Object)shortcut, (Object)"<no shortcut>")) {
            string = FeatureSuggesterBundle.INSTANCE.message("shortcut.not.found.message", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{shortcut};
            string = FeatureSuggesterBundle.INSTANCE.message("shortcut", objectArray);
        }
        return string;
    }
}

