/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@NonNls
public class VcsLogRepoSizeCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("vcs.log.data", 5);
    private static final EventId DATA_INITIALIZED = GROUP.registerEvent("dataInitialized");
    private static final EventId1<Integer> COMMIT_COUNT = GROUP.registerEvent("commit.count", (EventField)EventFields.Count);
    private static final EventId1<Integer> BRANCHES_COUNT = GROUP.registerEvent("branches.count", (EventField)EventFields.Count);
    private static final EventId1<Integer> USERS_COUNT = GROUP.registerEvent("users.count", (EventField)EventFields.Count);
    public static final StringEventField VCS_FIELD = new StringEventField("vcs"){

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = VcsLogRepoSizeCollector.getVcsValidationRule();
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector$1", "getValidationRule"));
        }
    };
    private static final EventId2<Integer, String> ROOT_COUNT = GROUP.registerEvent("root.count", (EventField)EventFields.Count, (EventField)VCS_FIELD);

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        DataPack dataPack;
        if (project == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(0);
        }
        if (!TrustedProjects.isProjectTrusted((Project)project)) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        VcsProjectLog projectLog = (VcsProjectLog)project.getServiceIfCreated(VcsProjectLog.class);
        if (projectLog == null) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        VcsLogData logData = projectLog.getDataManager();
        if (logData != null && (dataPack = logData.getDataPack()).isFull()) {
            int commitCount = dataPack.getPermanentGraph().getAllCommits().size();
            int branchesCount = dataPack.getRefsModel().getBranches().size();
            int usersCount = logData.getAllUsers().size();
            HashSet usages = ContainerUtil.newHashSet((Object[])new MetricEvent[]{DATA_INITIALIZED.metric()});
            usages.add(COMMIT_COUNT.metric((Object)StatisticsUtil.roundToPowerOfTwo((int)commitCount)));
            usages.add(BRANCHES_COUNT.metric((Object)StatisticsUtil.roundToPowerOfTwo((int)branchesCount)));
            usages.add(USERS_COUNT.metric((Object)StatisticsUtil.roundToPowerOfTwo((int)usersCount)));
            MultiMap<VcsKey, VirtualFile> groupedRoots = VcsLogRepoSizeCollector.groupRootsByVcs(dataPack.getLogProviders());
            for (VcsKey vcs : groupedRoots.keySet()) {
                int rootCount = groupedRoots.get((Object)vcs).size();
                usages.add(ROOT_COUNT.metric((Object)StatisticsUtil.roundToPowerOfTwo((int)rootCount), (Object)VcsLogRepoSizeCollector.getVcsKeySafe(vcs)));
            }
            HashSet hashSet = usages;
            if (hashSet == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(3);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public static String getVcsKeySafe(@NotNull VcsKey vcs) {
        if (vcs == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(5);
        }
        if (PluginInfoDetectorKt.getPluginInfo(vcs.getClass()).isDevelopedByJetBrains()) {
            String string = UsageDescriptorKeyValidator.ensureProperKey((String)StringUtil.toLowerCase((String)vcs.getName()));
            if (string == null) {
                VcsLogRepoSizeCollector.$$$reportNull$$$0(6);
            }
            return string;
        }
        return "third.party";
    }

    @NotNull
    static List<String> getVcsValidationRule() {
        List<String> list = List.of("{enum#vcs}", "{enum:third.party}");
        if (list == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static MultiMap<VcsKey, VirtualFile> groupRootsByVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(8);
        }
        MultiMap result = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsKey vcs = entry.getValue().getSupportedVcs();
            result.putValue((Object)vcs, (Object)root);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            VcsLogRepoSizeCollector.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsKeySafe";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsValidationRule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "groupRootsByVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVcsKeySafe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "groupRootsByVcs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

