/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JComboBox;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JComboBoxCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.util.Pair;

final class JComboBoxSelectionValueQuery {
    private static final Pair<Boolean, String> NO_SELECTION = Pair.of(false, null);

    @Nonnull
    @RunsInEDT
    static Pair<Boolean, String> selection(final @Nonnull JComboBox<?> comboBox, final @Nonnull JComboBoxCellReader cellReader) {
        Pair<Boolean, String> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, String>>(){

            @Override
            @Nullable
            protected Pair<Boolean, String> executeInEDT() {
                int selectedIndex = comboBox.getSelectedIndex();
                if (selectedIndex == -1) {
                    return JComboBoxSelectionValueQuery.valueForNoSelection(comboBox);
                }
                return JComboBoxSelectionValueQuery.selection(cellReader.valueAt(comboBox, selectedIndex));
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Nonnull
    private static Pair<Boolean, String> valueForNoSelection(@Nonnull JComboBox<?> comboBox) {
        if (!comboBox.isEditable()) {
            return NO_SELECTION;
        }
        Object selectedItem = comboBox.getSelectedItem();
        if (selectedItem instanceof String) {
            return JComboBoxSelectionValueQuery.selection((String)selectedItem);
        }
        if (selectedItem != null) {
            return JComboBoxSelectionValueQuery.selection(selectedItem.toString());
        }
        return NO_SELECTION;
    }

    @Nonnull
    private static Pair<Boolean, String> selection(@Nullable String selection) {
        return Pair.of(true, selection);
    }

    private JComboBoxSelectionValueQuery() {
    }
}

