/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.compat;

import com.intellij.maven.server.m40.InvokerWithoutCoreExtensions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.api.cli.InvokerRequest;

public class Maven40InvokerRequestFactory {
    private static final Map<String, Method> INVOKER_METHODS = new HashMap<String, Method>();

    public static InvokerRequest createProxy(InvokerRequest invokerRequest) {
        return (InvokerRequest)Proxy.newProxyInstance(Maven40InvokerRequestFactory.class.getClassLoader(), new Class[]{InvokerRequest.class, InvokerWithoutCoreExtensions.class}, (InvocationHandler)new InvokerProxyHandler(invokerRequest));
    }

    static {
        for (Method m : InvokerRequest.class.getMethods()) {
            INVOKER_METHODS.put(m.getName(), m);
        }
    }

    private static class InvokerProxyHandler
    implements InvocationHandler {
        private final InvokerRequest myInvokerRequest;
        private boolean coreExtensionsDisabled = false;

        public InvokerProxyHandler(InvokerRequest invoker) {
            this.myInvokerRequest = invoker;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("disableCoreExtensions")) {
                this.coreExtensionsDisabled = true;
                return null;
            }
            if (method.getName().equals("coreExtensions")) {
                if (this.coreExtensionsDisabled) {
                    return Optional.empty();
                }
                return this.myInvokerRequest.coreExtensions();
            }
            if (method.getName().equals("toString")) {
                return "[Proxy]:" + this.myInvokerRequest.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.myInvokerRequest.hashCode();
            }
            Method realMethod = INVOKER_METHODS.get(method.getName());
            if (realMethod == null || args != null && args.length > 0) {
                throw new UnsupportedOperationException(method.getName() + " is not supported in this IDEA version");
            }
            return realMethod.invoke((Object)this.myInvokerRequest, new Object[0]);
        }
    }
}

