/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.type.DataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.storage.StorageManagerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJJ\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0001\"\b\b\u0001\u0010\u0010*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014JB\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0001\"\b\b\u0001\u0010\u0010*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u0017J\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\fJ\u0016\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012J\u001e\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0012R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/jps/incremental/storage/StorageManager;", "", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "store", "Lorg/h2/mvstore/MVStore;", "(Ljava/nio/file/Path;Lorg/h2/mvstore/MVStore;)V", "storeValue", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "open", "", "openMap", "Lorg/h2/mvstore/MVMap;", "K", "V", "name", "", "keyType", "Lorg/h2/mvstore/type/DataType;", "valueType", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "forceClose", "close", "commit", "clearCache", "clean", "removeMaps", "targetId", "targetTypeId", "getMapName", "suffix", "intellij.platform.jps.build"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageManager.kt\norg/jetbrains/jps/incremental/storage/StorageManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,231:1\n61#2,5:232\n61#2,5:241\n24#3:237\n63#3,3:238\n*S KotlinDebug\n*F\n+ 1 StorageManager.kt\norg/jetbrains/jps/incremental/storage/StorageManager\n*L\n43#1:232,5\n27#1:241,5\n80#1:237\n80#1:238,3\n*E\n"})
public final class StorageManager {
    @JvmField
    @NotNull
    public final Path file;
    @NotNull
    private final SynchronizedClearableLazy<MVStore> storeValue;

    public StorageManager(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.storeValue = new SynchronizedClearableLazy(() -> StorageManager.storeValue$lambda$2(this));
    }

    public StorageManager(@NotNull Path file, @NotNull MVStore store) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this(file);
        this.storeValue.setValue((Object)store);
    }

    public final void open() {
        this.storeValue.getValue();
    }

    @NotNull
    public final <K, V> MVMap<K, V> openMap(@NotNull String name, @NotNull DataType<K> keyType, @NotNull DataType<V> valueType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        Logger $this$debug_u24default$iv = StorageManagerKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Open map " + name, e$iv);
        }
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.setKeyType(keyType);
        mapBuilder.setValueType(valueType);
        return this.openMap(name, mapBuilder);
    }

    @NotNull
    public final <K, V> MVMap<K, V> openMap(@NotNull String name, @NotNull MVMap.Builder<K, V> mapBuilder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(mapBuilder, (String)"mapBuilder");
        return StorageManagerKt.access$openOrResetMap((MVStore)this.storeValue.getValue(), name, mapBuilder, StorageManager::openMap$lambda$4);
    }

    public final void forceClose() {
        block1: {
            MVStore mVStore = (MVStore)this.storeValue.drop();
            if (mVStore == null) break block1;
            MVStore it = mVStore;
            boolean bl = false;
            if (StorageManagerKt.access$getLOG$p().isDebugEnabled()) {
                StorageManagerKt.access$getLOG$p().debug("Force closing storage " + this.file, new Throwable());
            }
            it.closeImmediately();
        }
    }

    public final void close() {
        MVStore mVStore = (MVStore)this.storeValue.drop();
        if (mVStore == null) {
            return;
        }
        MVStore store = mVStore;
        if (StorageManagerKt.access$getLOG$p().isDebugEnabled()) {
            StorageManagerKt.access$getLOG$p().debug("Closing storage " + this.file, new Throwable());
        }
        boolean isCompactOnClose = Boolean.parseBoolean(System.getProperty("jps.new.storage.compact.on.close", "false"));
        store.close();
        if (isCompactOnClose && Files.exists(this.file, new LinkOption[0])) {
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            MVStoreTool.compact((String)((Object)this.file).toString(), (boolean)false);
            long time = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            StorageManagerKt.access$getLOG$p().info("Compacted storage in " + Duration.toString-impl((long)time));
        }
    }

    public final void commit() {
        block0: {
            MVStore mVStore = (MVStore)this.storeValue.getValueIfInitialized();
            if (mVStore == null) break block0;
            mVStore.tryCommit();
        }
    }

    public final void clearCache() {
        block0: {
            MVStore mVStore = (MVStore)this.storeValue.getValueIfInitialized();
            if (mVStore == null) break block0;
            mVStore.setCacheSize(StorageManagerKt.access$getMV_STORE_CACHE_SIZE_IN_MB$p() * 1024);
        }
    }

    public final void clean() {
        MVStore store = (MVStore)this.storeValue.getValueIfInitialized();
        if (store == null) {
            Files.deleteIfExists(this.file);
        } else {
            for (String mapName : store.getMapNames()) {
                store.removeMap(mapName);
            }
        }
    }

    public final void removeMaps(@NotNull String targetId, @NotNull String targetTypeId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
        MVStore store = (MVStore)this.storeValue.getValue();
        for (String mapName : store.getMapNames()) {
            Intrinsics.checkNotNull((Object)mapName);
            if (!StringsKt.startsWith$default((String)mapName, (String)this.getMapName(targetId, targetTypeId, ""), (boolean)false, (int)2, null)) continue;
            store.removeMap(mapName);
        }
    }

    @NotNull
    public final String getMapName(@NotNull String targetId, @NotNull String targetTypeId, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return targetId + "|" + targetTypeId + "|" + suffix;
    }

    private static final Unit storeValue$lambda$2$lambda$1(String m, Throwable e, boolean isWarn) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (isWarn) {
            StorageManagerKt.access$getLOG$p().warn(m, e);
        } else {
            StorageManagerKt.access$getLOG$p().error(m, e);
        }
        return Unit.INSTANCE;
    }

    private static final MVStore storeValue$lambda$2(StorageManager this$0) {
        Logger $this$debug_u24default$iv = StorageManagerKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Opening storage " + this$0.file, e$iv);
        }
        return StorageManagerKt.createOrResetMvStore$default(this$0.file, false, StorageManager::storeValue$lambda$2$lambda$1, 0, 8, null);
    }

    private static final Unit openMap$lambda$4(String m, Throwable e, boolean isWarn) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StorageManagerKt.access$getLOG$p().warn(m, e);
        return Unit.INSTANCE;
    }
}

