/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.java.ElementAnnotation;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.JvmProtoMemberValueExternalizer;
import org.jetbrains.jps.dependency.java.MemberUsage;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.TypeRepr;

public abstract class ProtoMember
extends Proto {
    @NotNull
    private final TypeRepr type;
    @Nullable
    private final Object value;

    public ProtoMember(JVMFlags flags, String signature, String name, @NotNull TypeRepr type, @NotNull Iterable<ElementAnnotation> annotations, @Nullable Object value) {
        if (type == null) {
            ProtoMember.$$$reportNull$$$0(0);
        }
        if (annotations == null) {
            ProtoMember.$$$reportNull$$$0(1);
        }
        super(flags, signature, name, annotations);
        this.type = type;
        this.value = value;
    }

    public ProtoMember(GraphDataInput in) throws IOException {
        super(in);
        this.type = TypeRepr.getType(in.readUTF());
        this.value = JvmProtoMemberValueExternalizer.read(in);
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.type.getDescriptor());
        JvmProtoMemberValueExternalizer.write(out, this.value);
    }

    public abstract MemberUsage createUsage(JvmNodeReferenceID var1);

    @NotNull
    public TypeRepr getType() {
        TypeRepr typeRepr = this.type;
        if (typeRepr == null) {
            ProtoMember.$$$reportNull$$$0(2);
        }
        return typeRepr;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/ProtoMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/ProtoMember";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Diff<V extends ProtoMember>
    extends Proto.Diff<V> {
        final /* synthetic */ ProtoMember this$0;

        public Diff(V past) {
            this.this$0 = this$0;
            super((Proto)this$0, past);
        }

        @Override
        public boolean unchanged() {
            return super.unchanged() && !this.typeChanged() && !this.valueChanged();
        }

        public boolean typeChanged() {
            return !Objects.equals(((ProtoMember)this.myPast).getType(), this.this$0.getType());
        }

        public boolean valueChanged() {
            return !Objects.deepEquals(((ProtoMember)this.myPast).getValue(), this.this$0.getValue());
        }

        public boolean valueAdded() {
            return ((ProtoMember)this.myPast).getValue() == null && this.this$0.getValue() != null;
        }

        public boolean valueRemoved() {
            return ((ProtoMember)this.myPast).getValue() != null && this.this$0.getValue() == null;
        }
    }
}

