/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmMetadata;
import org.jetbrains.jps.dependency.java.ModulePackage;
import org.jetbrains.jps.dependency.java.ModuleRequires;
import org.jetbrains.jps.dependency.java.Utils;

public final class JvmModule
extends JVMClassNode<JvmModule, Diff> {
    private final String myVersion;
    private final Iterable<ModuleRequires> myRequires;
    private final Iterable<ModulePackage> myExports;

    public JvmModule(JVMFlags flags, String name, String outFilePath, String version, @NotNull Iterable<ModuleRequires> requires, @NotNull Iterable<ModulePackage> exports, @NotNull Iterable<Usage> usages, @NotNull Iterable<JvmMetadata<?, ?>> metadata) {
        if (requires == null) {
            JvmModule.$$$reportNull$$$0(0);
        }
        if (exports == null) {
            JvmModule.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            JvmModule.$$$reportNull$$$0(2);
        }
        if (metadata == null) {
            JvmModule.$$$reportNull$$$0(3);
        }
        super(flags, "", name, outFilePath, Collections.emptyList(), usages, metadata);
        this.myVersion = version == null ? "" : version;
        this.myRequires = requires;
        this.myExports = exports;
    }

    public JvmModule(GraphDataInput in) throws IOException {
        super(in);
        this.myVersion = in.readUTF();
        this.myRequires = RW.readCollection(in, () -> new ModuleRequires(in));
        this.myExports = RW.readCollection(in, () -> new ModulePackage(in));
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myVersion);
        RW.writeCollection(out, this.myRequires, r -> r.write(out));
        RW.writeCollection(out, this.myExports, p -> p.write(out));
    }

    public String getVersion() {
        return this.myVersion;
    }

    public Iterable<ModuleRequires> getRequires() {
        return this.myRequires;
    }

    public Iterable<ModulePackage> getExports() {
        return this.myExports;
    }

    public boolean requiresTransitively(String requirementName) {
        for (ModuleRequires require : this.getRequires()) {
            if (!Objects.equals(require.getName(), requirementName)) continue;
            return require.getFlags().isTransitive();
        }
        return false;
    }

    @Override
    public Diff difference(JvmModule past) {
        return new Diff(past);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "requires";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "exports";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "usages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "metadata";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/dependency/java/JvmModule";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public final class Diff
    extends JVMClassNode.Diff {
        private final Supplier<Difference.Specifier<ModuleRequires, ModuleRequires.Diff>> myRequiresDiff;
        private final Supplier<Difference.Specifier<ModulePackage, ModulePackage.Diff>> myExportsDiff;

        public Diff(JvmModule past) {
            super((JVMClassNode)JvmModule.this, (JVMClassNode)past);
            this.myRequiresDiff = Utils.lazyValue(() -> Difference.deepDiff(((JvmModule)this.myPast).getRequires(), JvmModule.this.getRequires()));
            this.myExportsDiff = Utils.lazyValue(() -> Difference.deepDiff(((JvmModule)this.myPast).getExports(), JvmModule.this.getExports()));
        }

        @Override
        public boolean unchanged() {
            return super.unchanged() && !this.versionChanged() && this.requires().unchanged() && this.exports().unchanged();
        }

        public Difference.Specifier<ModuleRequires, ModuleRequires.Diff> requires() {
            return this.myRequiresDiff.get();
        }

        public Difference.Specifier<ModulePackage, ModulePackage.Diff> exports() {
            return this.myExportsDiff.get();
        }

        public boolean versionChanged() {
            return !Objects.equals(((JvmModule)this.myPast).getVersion(), JvmModule.this.getVersion());
        }
    }
}

