/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

@ApiStatus.Internal
public final class BuildTargetRegistryImpl
implements BuildTargetRegistry {
    private final @Unmodifiable List<BuildTarget<?>> allTargets;
    private final @Unmodifiable Map<BuildTargetType<?>, List<? extends BuildTarget<?>>> targets;
    private final @Unmodifiable Map<JpsModule, List<ModuleBasedTarget<?>>> moduleBasedTargets;

    public BuildTargetRegistryImpl(JpsModel model) {
        HashMap targets = new HashMap();
        HashMap<JpsModule, ArrayList<ModuleBasedTarget>> moduleBasedTargets = new HashMap<JpsModule, ArrayList<ModuleBasedTarget>>();
        ArrayList allTargets = new ArrayList();
        for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
            List<?> targetsPerType = type.computeAllTargets(model);
            targets.put(type, targetsPerType);
            allTargets.addAll(targetsPerType);
            for (BuildTarget target : targetsPerType) {
                if (!(target instanceof ModuleBasedTarget)) continue;
                ModuleBasedTarget t = (ModuleBasedTarget)target;
                JpsModule module = t.getModule();
                ArrayList<ModuleBasedTarget> list = (ArrayList<ModuleBasedTarget>)moduleBasedTargets.get(module);
                if (list == null) {
                    list = new ArrayList<ModuleBasedTarget>();
                    moduleBasedTargets.put(module, list);
                }
                list.add(t);
            }
        }
        this.targets = Map.copyOf(targets);
        this.moduleBasedTargets = Map.copyOf(moduleBasedTargets);
        this.allTargets = List.copyOf(allTargets);
    }

    @Override
    @NotNull
    public Collection<ModuleBasedTarget<?>> getModuleBasedTargets(@NotNull JpsModule module, @NotNull BuildTargetRegistry.ModuleTargetSelector selector) {
        List<ModuleBasedTarget<?>> targets;
        if (module == null) {
            BuildTargetRegistryImpl.$$$reportNull$$$0(0);
        }
        if (selector == null) {
            BuildTargetRegistryImpl.$$$reportNull$$$0(1);
        }
        if ((targets = this.moduleBasedTargets.get(module)) == null || targets.isEmpty()) {
            List<ModuleBasedTarget<?>> list = List.of();
            if (list == null) {
                BuildTargetRegistryImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList result = new ArrayList();
        for (ModuleBasedTarget<?> target : targets) {
            switch (selector) {
                case ALL: {
                    result.add(target);
                    break;
                }
                case PRODUCTION: {
                    if (target.isTests()) break;
                    result.add(target);
                    break;
                }
                case TEST: {
                    if (!target.isTests()) break;
                    result.add(target);
                }
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            BuildTargetRegistryImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public <T extends BuildTarget<?>> List<T> getAllTargets(@NotNull BuildTargetType<T> type) {
        if (type == null) {
            BuildTargetRegistryImpl.$$$reportNull$$$0(4);
        }
        List list = this.targets.getOrDefault(type, List.of());
        if (list == null) {
            BuildTargetRegistryImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<BuildTarget<?>> getAllTargets() {
        List<BuildTarget<?>> list = this.allTargets;
        if (list == null) {
            BuildTargetRegistryImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/impl/BuildTargetRegistryImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleBasedTargets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleBasedTargets";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

