/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.vectorization;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.util.Optional;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.vectorization.Lucene99MemorySegmentByteVectorScorerSupplier;
import org.apache.lucene.store.FilterIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MemorySegmentAccessInput;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Lucene99MemorySegmentByteVectorScorerSupplier
implements RandomVectorScorerSupplier {
    final int vectorByteSize;
    final int maxOrd;
    final MemorySegmentAccessInput input;
    final RandomAccessVectorValues values;
    byte[] scratch1;
    byte[] scratch2;

    static Optional<RandomVectorScorerSupplier> create(VectorSimilarityFunction type, IndexInput input, RandomAccessVectorValues values) {
        if (!((input = FilterIndexInput.unwrapOnlyTest(input)) instanceof MemorySegmentAccessInput)) {
            return Optional.empty();
        }
        MemorySegmentAccessInput msInput = (MemorySegmentAccessInput)input;
        Lucene99MemorySegmentByteVectorScorerSupplier.checkInvariants((int)values.size(), (int)values.getVectorByteLength(), (IndexInput)input);
        if (type == VectorSimilarityFunction.COSINE) {
            return Optional.of(new CosineSupplier(msInput, values));
        }
        if (type == VectorSimilarityFunction.DOT_PRODUCT) {
            return Optional.of(new DotProductSupplier(msInput, values));
        }
        if (type == VectorSimilarityFunction.EUCLIDEAN) {
            return Optional.of(new EuclideanSupplier(msInput, values));
        }
        if (type == VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT) {
            return Optional.of(new MaxInnerProductSupplier(msInput, values));
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    Lucene99MemorySegmentByteVectorScorerSupplier(MemorySegmentAccessInput input, RandomAccessVectorValues values) {
        this.input = input;
        this.values = values;
        this.vectorByteSize = values.getVectorByteLength();
        this.maxOrd = values.size();
    }

    static void checkInvariants(int maxOrd, int vectorByteLength, IndexInput input) {
        if (input.length() < (long)vectorByteLength * (long)maxOrd) {
            throw new IllegalArgumentException("input length is less than expected vector data");
        }
    }

    final void checkOrdinal(int ord) {
        if (ord < 0 || ord >= this.maxOrd) {
            throw new IllegalArgumentException("illegal ordinal: " + ord);
        }
    }

    final MemorySegment getFirstSegment(int ord) throws IOException {
        long byteOffset = (long)ord * (long)this.vectorByteSize;
        MemorySegment seg = this.input.segmentSliceOrNull(byteOffset, (long)this.vectorByteSize);
        if (seg == null) {
            if (this.scratch1 == null) {
                this.scratch1 = new byte[this.vectorByteSize];
            }
            this.input.readBytes(byteOffset, this.scratch1, 0, this.vectorByteSize);
            seg = MemorySegment.ofArray(this.scratch1);
        }
        return seg;
    }

    final MemorySegment getSecondSegment(int ord) throws IOException {
        long byteOffset = (long)ord * (long)this.vectorByteSize;
        MemorySegment seg = this.input.segmentSliceOrNull(byteOffset, (long)this.vectorByteSize);
        if (seg == null) {
            if (this.scratch2 == null) {
                this.scratch2 = new byte[this.vectorByteSize];
            }
            this.input.readBytes(byteOffset, this.scratch2, 0, this.vectorByteSize);
            seg = MemorySegment.ofArray(this.scratch2);
        }
        return seg;
    }
}

