/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.navigator.structure.ArtifactNode;
import org.jetbrains.idea.maven.navigator.structure.BaseDependenciesNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

class DependencyNode
extends BaseDependenciesNode
implements ArtifactNode {
    private final MavenArtifact myArtifact;
    private final MavenArtifactNode myArtifactNode;
    private final boolean myUnresolved;

    DependencyNode(MavenProjectsStructure structure, MavenSimpleNode parent, MavenArtifactNode artifactNode, MavenProject mavenProject, boolean unresolved) {
        super(structure, parent, mavenProject);
        this.myArtifactNode = artifactNode;
        this.myArtifact = artifactNode.getArtifact();
        this.myUnresolved = unresolved;
        this.getTemplatePresentation().setIcon(AllIcons.Nodes.PpLib);
    }

    @Override
    public MavenArtifact getArtifact() {
        return this.myArtifact;
    }

    public boolean isUnresolved() {
        return this.myUnresolved;
    }

    public String getName() {
        return this.myArtifact.getDisplayStringForLibraryName();
    }

    private String getToolTip() {
        StringBuilder myToolTip = new StringBuilder();
        String scope = this.myArtifactNode.getOriginalScope();
        if (StringUtil.isNotEmpty((String)scope) && !"compile".equals(scope)) {
            myToolTip.append(scope).append(" ");
        }
        if (this.myArtifactNode.getState() == MavenArtifactState.CONFLICT) {
            myToolTip.append("omitted for conflict");
            if (this.myArtifactNode.getRelatedArtifact() != null) {
                myToolTip.append(" with ").append(this.myArtifactNode.getRelatedArtifact().getVersion());
            }
        }
        if (this.myArtifactNode.getState() == MavenArtifactState.DUPLICATE) {
            myToolTip.append("omitted for duplicate");
        }
        return myToolTip.toString().trim();
    }

    @Override
    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            DependencyNode.$$$reportNull$$$0(0);
        }
        this.setNameAndTooltip(presentation, this.getName(), null, this.getToolTip());
    }

    @Override
    protected void setNameAndTooltip(@NotNull PresentationData presentation, String name, @Nullable String tooltip, SimpleTextAttributes attributes) {
        if (presentation == null) {
            DependencyNode.$$$reportNull$$$0(1);
        }
        SimpleTextAttributes mergedAttributes = this.myArtifactNode.getState() == MavenArtifactState.CONFLICT || this.myArtifactNode.getState() == MavenArtifactState.DUPLICATE ? SimpleTextAttributes.merge((SimpleTextAttributes)attributes, (SimpleTextAttributes)SimpleTextAttributes.GRAYED_ATTRIBUTES) : attributes;
        super.setNameAndTooltip(presentation, name, tooltip, mergedAttributes);
    }

    void updateDependency() {
        this.setErrorLevel(this.myUnresolved ? MavenProjectsStructure.ErrorLevel.ERROR : MavenProjectsStructure.ErrorLevel.NONE);
    }

    @Override
    public Navigatable getNavigatable() {
        VirtualFile file2;
        MavenArtifactNode parent = this.myArtifactNode.getParent();
        if (parent == null) {
            file2 = this.getMavenProject().getFile();
        } else {
            MavenId id = parent.getArtifact().getMavenId();
            MavenProject pr = MavenProjectsManager.getInstance(this.myProject).findProject(id);
            file2 = pr == null ? MavenNavigationUtil.getArtifactFile(this.getProject(), id) : pr.getFile();
        }
        return file2 == null ? null : MavenNavigationUtil.createNavigatableForDependency(this.getProject(), file2, this.getArtifact());
    }

    @Override
    public boolean isVisible() {
        return this.getDisplayKind() != MavenProjectsStructure.DisplayKind.NEVER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "presentation";
        objectArray2[1] = "org/jetbrains/idea/maven/navigator/structure/DependencyNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setNameAndTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

