/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.Maven3SpyOutputExtractor;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.Maven4SpyOutputExtractor;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.SpyOutputExtractor;

public class MavenSimpleConsoleEventsBuffer {
    private final TypedBuffer myBuffer;
    private final BiConsumer<String, Key<Object>> myConsumer;
    private final boolean myShowSpyOutput;
    private final boolean myHideWindowsExitMessage;

    private MavenSimpleConsoleEventsBuffer(BiConsumer<String, Key<Object>> consumer, boolean showSpyOutput, boolean withLoggingOutputStream, boolean hideWindowsMessage) {
        this.myConsumer = consumer;
        this.myShowSpyOutput = showSpyOutput;
        this.myHideWindowsExitMessage = hideWindowsMessage;
        this.myBuffer = new TypedBuffer(consumer, withLoggingOutputStream ? new Maven4SpyOutputExtractor() : new Maven3SpyOutputExtractor());
    }

    public void addText(@NotNull String text, @NotNull Key<Object> outputType) {
        if (text == null) {
            MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            MavenSimpleConsoleEventsBuffer.$$$reportNull$$$0(1);
        }
        if (this.myShowSpyOutput) {
            this.myConsumer.accept(text, outputType);
            return;
        }
        this.myBuffer.append(text, outputType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "outputType";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/execution/MavenSimpleConsoleEventsBuffer";
        objectArray[2] = "addText";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TypedBuffer {
        private final BiConsumer<String, @NotNull Key<Object>> myConsumer;
        private final SpyOutputExtractor myExtractor;
        private final List<OutputChunk> chunks = new ArrayList<OutputChunk>();
        private ProcessOutputType myBaseOutputType;
        private boolean myIsProcessingSpyNow;

        private TypedBuffer(BiConsumer<String, @NotNull Key<Object>> consumer, SpyOutputExtractor extractor) {
            this.myConsumer = consumer;
            this.myExtractor = extractor;
        }

        private void reset() {
            this.chunks.clear();
        }

        private void sendAndReset() {
            for (OutputChunk chunk : this.chunks) {
                this.myConsumer.accept(chunk.text, chunk.outputType);
            }
            this.reset();
        }

        private boolean canAppend(@NotNull Key<Object> outputType) {
            if (outputType == null) {
                TypedBuffer.$$$reportNull$$$0(0);
            }
            ProcessOutputType baseOutType = TypedBuffer.getBaseOutputType(outputType);
            return null == this.myBaseOutputType || baseOutType != null && baseOutType.equals((Object)this.myBaseOutputType);
        }

        @Nullable
        private static ProcessOutputType getBaseOutputType(Key<Object> outputType) {
            if (!(outputType instanceof ProcessOutputType)) {
                return null;
            }
            return ((ProcessOutputType)outputType).getBaseOutputType();
        }

        public void append(@NotNull String text, @NotNull Key<Object> outputType) {
            boolean lastChunk;
            if (text == null) {
                TypedBuffer.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                TypedBuffer.$$$reportNull$$$0(2);
            }
            boolean bl = lastChunk = text.charAt(text.length() - 1) == '\n';
            if (this.myIsProcessingSpyNow) {
                this.myIsProcessingSpyNow = !lastChunk;
                return;
            }
            if (!this.canAppend(outputType)) {
                this.sendAndReset();
            }
            this.chunks.add(new OutputChunk(text, outputType));
            this.myBaseOutputType = TypedBuffer.getBaseOutputType(outputType);
            String clearedBuffer = this.getAllInBuffer();
            if (this.myExtractor.isLengthEnough(clearedBuffer) || lastChunk) {
                if (!this.myExtractor.isSpyLog(clearedBuffer)) {
                    this.sendAndReset();
                } else {
                    this.myIsProcessingSpyNow = !lastChunk;
                    this.reset();
                }
            }
        }

        private String getAllInBuffer() {
            StringBuilder plainText = new StringBuilder();
            for (OutputChunk chunk : this.chunks) {
                plainText.append(chunk.text);
            }
            return plainText.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenSimpleConsoleEventsBuffer$TypedBuffer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canAppend";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "append";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record OutputChunk(String text, Key<Object> outputType) {
    }

    public static class Builder {
        private final BiConsumer<String, Key<Object>> consumer;
        private boolean showSpyOutput;
        private boolean loggingOutputStream;
        private boolean hideWindowsCmdMessage;

        public Builder(BiConsumer<String, Key<Object>> consumer) {
            this.consumer = consumer;
        }

        public Builder withSpyOutput(boolean v) {
            this.showSpyOutput = v;
            return this;
        }

        public Builder withLoggingOutputStream(boolean v) {
            this.loggingOutputStream = v;
            return this;
        }

        public Builder withHidingCmdExitQuestion(boolean v) {
            this.hideWindowsCmdMessage = v;
            return this;
        }

        public MavenSimpleConsoleEventsBuffer build() {
            return new MavenSimpleConsoleEventsBuffer(this.consumer, this.showSpyOutput, this.loggingOutputStream, this.hideWindowsCmdMessage);
        }
    }
}

