/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.MultipleRepositoryUrlsFix;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public final class MultipleRepositoryUrlsInspection
extends GradleBaseInspection {
    @NotNull
    public GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = BaseInspection.getProbableBugs();
        if (string == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    static List<GrCallExpression> findUrlCallExpressions(@NotNull GrClosableBlock closure) {
        GrCallExpression[] applicationStatements;
        if (closure == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(2);
        }
        if ((applicationStatements = (GrCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)closure, GrCallExpression.class)) == null) {
            List<GrCallExpression> list = Collections.emptyList();
            if (list == null) {
                MultipleRepositoryUrlsInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<GrCallExpression> statements = new ArrayList<GrCallExpression>();
        for (GrCallExpression statement : applicationStatements) {
            GrReferenceExpression[] referenceExpressions = (GrReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)statement, GrReferenceExpression.class);
            if (referenceExpressions == null) continue;
            for (GrReferenceExpression expression : referenceExpressions) {
                String expressionText = expression.getText();
                if (!"url".equals(expressionText) && !"setUrl".equals(expressionText)) continue;
                statements.add(statement);
            }
        }
        ArrayList<GrCallExpression> arrayList = statements;
        if (arrayList == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUrlCallExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildGroovyVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUrlCallExpressions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends GroovyElementVisitor {
        private final ProblemsHolder myHolder;

        MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitClosure(@NotNull GrClosableBlock closure) {
            PsiFile file;
            if (closure == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if ((file = closure.getContainingFile()) == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                return;
            }
            super.visitClosure(closure);
            GrMethodCall mavenMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)closure, GrMethodCall.class);
            if (mavenMethodCall == null) {
                return;
            }
            GrExpression mavenMethodExpression = mavenMethodCall.getInvokedExpression();
            if (!ArrayUtil.contains((String)mavenMethodExpression.getText(), (String[])new String[]{"maven", "ivy"})) {
                return;
            }
            GrMethodCall repositoryMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)mavenMethodCall, GrMethodCall.class);
            if (repositoryMethodCall == null) {
                return;
            }
            GrExpression repositoryMethodExpression = repositoryMethodCall.getInvokedExpression();
            if (!repositoryMethodExpression.getText().equals("repositories")) {
                return;
            }
            List<GrCallExpression> statements = MultipleRepositoryUrlsInspection.findUrlCallExpressions(closure);
            if (statements.size() > 1) {
                this.myHolder.registerProblem((PsiElement)closure, GradleInspectionBundle.message("multiple.repository.urls", new Object[0]), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{new MultipleRepositoryUrlsFix(mavenMethodExpression.getText())});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection$MyVisitor", "visitClosure"));
        }
    }
}

