/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.TextBufferChangesListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/terminal/backend/TerminalDiscardedHistoryTracker;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;)V", "discardedLogicalLinesCount", "", "getDiscardedLogicalLinesCount", "intellij.terminal.backend"})
public final class TerminalDiscardedHistoryTracker {
    @NotNull
    private final TerminalTextBuffer textBuffer;
    private long discardedLogicalLinesCount;

    public TerminalDiscardedHistoryTracker(@NotNull TerminalTextBuffer textBuffer) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        this.textBuffer = textBuffer;
        this.textBuffer.addChangesListener(new TextBufferChangesListener(){

            public void linesDiscardedFromHistory(List<TerminalLine> lines) {
                Intrinsics.checkNotNullParameter(lines, (String)"lines");
                if (textBuffer.isUsingAlternateBuffer()) {
                    return;
                }
                for (TerminalLine line : lines) {
                    if (line.isWrapped()) continue;
                    long l = discardedLogicalLinesCount;
                    discardedLogicalLinesCount = l + 1L;
                }
            }

            public void historyCleared() {
                if (!textBuffer.isUsingAlternateBuffer()) {
                    discardedLogicalLinesCount = 0L;
                }
            }

            public void linesChanged(int fromIndex) {
                TextBufferChangesListener.DefaultImpls.linesChanged((TextBufferChangesListener)this, (int)fromIndex);
            }

            public void widthResized() {
                TextBufferChangesListener.DefaultImpls.widthResized((TextBufferChangesListener)this);
            }
        });
    }

    public final long getDiscardedLogicalLinesCount() {
        return this.textBuffer.isUsingAlternateBuffer() ? 0L : this.discardedLogicalLinesCount;
    }
}

