/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public class WhiteSpaceBeforeParagraphEnd
extends TextLevelRule {
    private final Language lang;

    public WhiteSpaceBeforeParagraphEnd(ResourceBundle messages, Language lang, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.lang = lang;
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setOfficeDefaultOn();
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public WhiteSpaceBeforeParagraphEnd(ResourceBundle messages, Language lang) {
        this(messages, lang, false);
    }

    @Override
    public String getId() {
        return "WHITESPACE_PARAGRAPH";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("whitespace_before_parapgraph_end_desc");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedSentence sentence = sentences.get(n);
            if (Tools.isParagraphEnd(sentences, n, this.lang)) {
                int lw;
                int lb;
                AnalyzedTokenReadings[] tokens = sentence.getTokens();
                for (lb = tokens.length - 1; lb > 0 && tokens[lb].isLinebreak(); --lb) {
                }
                for (lw = lb; lw > 0 && tokens[lw].isWhitespace() && !tokens[lw].getToken().equals("\u200b"); --lw) {
                }
                if (lw < lb) {
                    int fromPos = tokens[lw].isWhitespace() ? pos + tokens[lw + 1].getStartPos() : pos + tokens[lw].getStartPos();
                    int toPos = pos + tokens[lb].getEndPos();
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, fromPos, toPos, this.messages.getString("whitespace_before_parapgraph_end_msg"));
                    if (lw > 0 && !tokens[lw].isWhitespace()) {
                        ruleMatch.setSuggestedReplacement(tokens[lw].getToken());
                    } else {
                        ruleMatch.setSuggestedReplacement("");
                    }
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

