/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.common.plugin;

import com.intellij.editorconfig.common.plugin.IntellijEditorConfigTokenTypes;
import com.intellij.editorconfig.common.syntax.lexer._EditorConfigLexer;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;

public class IntellijEditorConfigLexerAdapter
extends FlexAdapter {
    private AdapterState myState = AdapterState.Initial;

    public IntellijEditorConfigLexerAdapter() {
        super((FlexLexer)new _EditorConfigLexer());
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (tokenType == EditorConfigElementTypes.DOT && this.myState == AdapterState.Value) {
            return IntellijEditorConfigTokenTypes.VALUE_CHAR;
        }
        return tokenType;
    }

    public void advance() {
        super.advance();
        if (this.getTokenText().contains("\n")) {
            this.myState = AdapterState.Initial;
        } else if (this.getCurrentPosition().getState() > 0) {
            this.myState = AdapterState.Header;
        } else {
            IElementType tokenType = this.getTokenType();
            switch (this.myState) {
                case Initial: {
                    if (tokenType != EditorConfigElementTypes.IDENTIFIER) break;
                    this.myState = AdapterState.Key;
                    break;
                }
                case Header: {
                    this.myState = AdapterState.Initial;
                    break;
                }
                case Key: {
                    if (tokenType != EditorConfigElementTypes.SEPARATOR) break;
                    this.myState = AdapterState.Value;
                    break;
                }
            }
        }
    }

    private static enum AdapterState {
        Initial,
        Header,
        Key,
        Value;

    }
}

