/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration.browser;

import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtilRt;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class GroupList
extends JPanel {
    private final JList<String> list;

    public GroupList(PsiClass[] classes) {
        super(new BorderLayout());
        SortedListModel model = new SortedListModel(Comparator.naturalOrder());
        this.list = new JBList((ListModel)model);
        Set<String> groups = TestNGUtil.getAnnotationValues("groups", classes);
        Object[] array = ArrayUtilRt.toStringArray(groups);
        Arrays.sort(array);
        model.addAll(array);
        this.add(ScrollPaneFactory.createScrollPane(this.list));
        this.list.setSelectionMode(0);
        ScrollingUtil.ensureSelectionExists(this.list);
    }

    public String getSelected() {
        return this.list.getSelectedValue();
    }

    public static String showDialog(PsiClass[] classes, JComponent component) {
        GroupList groupList = new GroupList(classes);
        DialogBuilder builder = new DialogBuilder((Component)component);
        builder.setCenterPanel((JComponent)groupList);
        builder.setPreferredFocusComponent(groupList.list);
        builder.setTitle(TestngBundle.message("testng.choose.test.group", new Object[0]));
        return builder.show() != 0 ? null : groupList.getSelected();
    }
}

