/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.GroovyPsiCreator;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubFileElementType;

public final class GroovyParserDefinition
implements ParserDefinition {
    public static final IStubFileElementType GROOVY_FILE = new GrStubFileElementType(GroovyLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        return new GroovyLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new GroovyParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IStubFileElementType iStubFileElementType = GROOVY_FILE;
        if (iStubFileElementType == null) {
            GroovyParserDefinition.$$$reportNull$$$0(0);
        }
        return iStubFileElementType;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSets.COMMENTS_TOKEN_SET;
        if (tokenSet == null) {
            GroovyParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSets.STRING_LITERALS;
        if (tokenSet == null) {
            GroovyParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = GroovyPsiCreator.createElement(node);
        if (psiElement == null) {
            GroovyParserDefinition.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            GroovyParserDefinition.$$$reportNull$$$0(4);
        }
        return new GroovyFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        IElementType lType = left.getElementType();
        IElementType rType = right.getElementType();
        if (rType == GroovyTokenTypes.kIMPORT && lType != TokenType.WHITE_SPACE) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(5);
            }
            return spaceRequirements;
        }
        if (lType == GroovyElementTypes.MODIFIER_LIST && rType == GroovyElementTypes.MODIFIER_LIST) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(6);
            }
            return spaceRequirements;
        }
        if (lType == GroovyTokenTypes.mSEMI) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        if (lType == GroovyTokenTypes.mSL_COMMENT) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(8);
            }
            return spaceRequirements;
        }
        if (lType == GroovyTokenTypes.mNLS || lType == GroovyDocTokenTypes.mGDOC_COMMENT_START) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(9);
            }
            return spaceRequirements;
        }
        if (lType == GroovyTokenTypes.mGT) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(10);
            }
            return spaceRequirements;
        }
        if (rType == GroovyTokenTypes.mLT) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(11);
            }
            return spaceRequirements;
        }
        ASTNode parent = TreeUtil.findCommonParent((ASTNode)left, (ASTNode)right);
        if (parent == null || ArrayUtil.contains((Object)parent.getElementType(), (Object[])new IElementType[]{GroovyElementTypes.GSTRING, GroovyElementTypes.REGEX, GroovyElementTypes.GSTRING_INJECTION, GroovyTokenTypes.mREGEX_LITERAL, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL})) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_NOT;
            if (spaceRequirements == null) {
                GroovyParserDefinition.$$$reportNull$$$0(12);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)new GroovyLexer());
        if (spaceRequirements == null) {
            GroovyParserDefinition.$$$reportNull$$$0(13);
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/parser/GroovyParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/parser/GroovyParserDefinition";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }
}

