/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.handlers;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public class AfterNewClassInsertHandler
implements InsertHandler<LookupElement> {
    private final PsiClassType myClassType;
    private final boolean myTriggerFeature;

    public AfterNewClassInsertHandler(PsiClassType classType, boolean triggerFeature) {
        this.myClassType = classType;
        this.myTriggerFeature = triggerFeature;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        boolean hasParams;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        if (context == null) {
            AfterNewClassInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            AfterNewClassInsertHandler.$$$reportNull$$$0(1);
        }
        if ((psiClass = (resolveResult = this.myClassType.resolveGenerics()).getElement()) == null || !psiClass.isValid()) {
            return;
        }
        GroovyPsiElement place = (GroovyPsiElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), GroovyPsiElement.class, (boolean)false);
        boolean bl = hasParams = place != null && GroovyCompletionUtil.hasConstructorParameters(psiClass, place);
        if (this.myTriggerFeature) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.afternew");
        }
        if (hasParams) {
            ParenthesesInsertHandler.WITH_PARAMETERS.handleInsert(context, item);
        } else {
            ParenthesesInsertHandler.NO_PARAMETERS.handleInsert(context, item);
        }
        AfterNewClassInsertHandler.shortenRefsInGenerics(context);
        if (hasParams) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
        if (psiClass.hasModifierProperty("abstract")) {
            Editor editor = context.getEditor();
            int offset = context.getTailOffset();
            editor.getDocument().insertString(offset, (CharSequence)" {}");
            editor.getCaretModel().moveToOffset(offset + 2);
            context.setLaterRunnable(AfterNewClassInsertHandler.generateAnonymousBody(editor, context.getFile()));
        }
    }

    private static void shortenRefsInGenerics(InsertionContext context) {
        int offset = context.getStartOffset();
        String text = context.getDocument().getText();
        while (text.charAt(offset) != '<' && text.charAt(offset) != '(') {
            ++offset;
        }
        if (text.charAt(offset) == '<') {
            GroovyCompletionUtil.shortenReference(context.getFile(), offset);
        }
    }

    @Nullable
    private static Runnable generateAnonymousBody(Editor editor, PsiFile file) {
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent().getParent();
        if (!(parent instanceof PsiAnonymousClass)) {
            return null;
        }
        return ConstructorInsertHandler.genAnonymousBodyFor((PsiAnonymousClass)((PsiAnonymousClass)parent), (Editor)editor, (PsiFile)file, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/handlers/AfterNewClassInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

