/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ConjunctionPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

public final class DemorgansLawIntention
extends GrPsiUpdateIntention {
    @Override
    @NotNull
    public String getText(@NotNull PsiElement element) {
        GrBinaryExpression binaryExpression;
        IElementType tokenType;
        if (element == null) {
            DemorgansLawIntention.$$$reportNull$$$0(0);
        }
        if (GroovyTokenTypes.mLAND.equals(tokenType = (binaryExpression = (GrBinaryExpression)element).getOperationTokenType())) {
            String string = GroovyIntentionsBundle.message("demorgans.intention.name1", new Object[0]);
            if (string == null) {
                DemorgansLawIntention.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = GroovyIntentionsBundle.message("demorgans.intention.name2", new Object[0]);
        if (string == null) {
            DemorgansLawIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            DemorgansLawIntention.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DemorgansLawIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            DemorgansLawIntention.$$$reportNull$$$0(5);
        }
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        PsiElement parent = exp.getParent();
        while (DemorgansLawIntention.isConjunctionExpression(parent, tokenType)) {
            exp = (GrBinaryExpression)parent;
            assert (exp != null);
            parent = exp.getParent();
        }
        String newExpression = DemorgansLawIntention.convertConjunctionExpression(exp, tokenType);
        DemorgansLawIntention.replaceExpressionWithNegatedExpressionString(newExpression, exp);
    }

    private static String convertConjunctionExpression(GrBinaryExpression exp, IElementType tokenType) {
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = DemorgansLawIntention.isConjunctionExpression(lhs, tokenType) ? DemorgansLawIntention.convertConjunctionExpression((GrBinaryExpression)lhs, tokenType) : DemorgansLawIntention.convertLeafExpression(lhs);
        GrExpression rhs = exp.getRightOperand();
        String rhsText = DemorgansLawIntention.isConjunctionExpression(rhs, tokenType) ? DemorgansLawIntention.convertConjunctionExpression((GrBinaryExpression)rhs, tokenType) : DemorgansLawIntention.convertLeafExpression(rhs);
        String flippedConjunction = tokenType.equals(GroovyTokenTypes.mLAND) ? "||" : "&&";
        return lhsText + flippedConjunction + rhsText;
    }

    private static String convertLeafExpression(GrExpression condition) {
        if (BoolUtils.isNegation(condition)) {
            GrExpression negated = BoolUtils.getNegated(condition);
            if (ParenthesesUtils.getPrecedence(negated) > ParenthesesUtils.OR_PRECEDENCE) {
                return "(" + negated.getText() + ")";
            }
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + condition.getText() + ")";
        }
        return "!" + condition.getText();
    }

    private static boolean isConjunctionExpression(PsiElement exp, IElementType conjunctionType) {
        if (!(exp instanceof GrBinaryExpression)) {
            return false;
        }
        GrBinaryExpression binExp = (GrBinaryExpression)exp;
        IElementType tokenType = binExp.getOperationTokenType();
        return conjunctionType.equals(tokenType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/DemorgansLawIntention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/DemorgansLawIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

