/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.FileChannelInterruptsRetryer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ResilientFileChannel
extends FileChannel {
    private final FileChannelInterruptsRetryer fileChannelHandle;
    private long position;

    public ResilientFileChannel(@NotNull Path path, OpenOption ... openOptions) throws IOException {
        Set openOptionsSet;
        if (path == null) {
            ResilientFileChannel.$$$reportNull$$$0(0);
        }
        if (openOptions == null) {
            ResilientFileChannel.$$$reportNull$$$0(1);
        }
        this.position = 0L;
        if (openOptions.length == 0) {
            openOptionsSet = Collections.emptySet();
        } else {
            openOptionsSet = new HashSet();
            Collections.addAll(openOptionsSet, openOptions);
        }
        this.fileChannelHandle = new FileChannelInterruptsRetryer(path, openOptionsSet);
    }

    public ResilientFileChannel(@NotNull Path path, Set<? extends @NotNull OpenOption> openOptions) throws IOException {
        if (path == null) {
            ResilientFileChannel.$$$reportNull$$$0(2);
        }
        this.position = 0L;
        this.fileChannelHandle = new FileChannelInterruptsRetryer(path, openOptions);
    }

    public <T> T executeOperation(@NotNull FileChannelInterruptsRetryer.FileChannelIdempotentOperation<T> operation) throws IOException {
        if (operation == null) {
            ResilientFileChannel.$$$reportNull$$$0(3);
        }
        return this.fileChannelHandle.retryIfInterrupted(operation);
    }

    @Override
    public long size() throws IOException {
        return this.fileChannelHandle.retryIfInterrupted(ch -> ch.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel truncate(long size) throws IOException {
        ResilientFileChannel resilientFileChannel = this;
        synchronized (resilientFileChannel) {
            this.position = Math.min(this.position, size);
        }
        return this.fileChannelHandle.retryIfInterrupted(ch -> ch.truncate(size));
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.fileChannelHandle.retryIfInterrupted(ch -> {
            ch.force(metaData);
            return null;
        });
    }

    @Override
    public int read(ByteBuffer target, long offset) throws IOException {
        int bufferPos = target.position();
        return this.fileChannelHandle.retryIfInterrupted(ch -> {
            target.position(bufferPos);
            return ch.read(target, offset);
        });
    }

    @Override
    public int write(ByteBuffer source, long offset) throws IOException {
        int bufferPos = source.position();
        return this.fileChannelHandle.retryIfInterrupted(ch -> {
            source.position(bufferPos);
            return ch.write(source, offset);
        });
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long mapRegionOffset, long mapRegionSize) throws IOException {
        return this.fileChannelHandle.retryIfInterrupted(ch -> ch.map(mapMode, mapRegionOffset, mapRegionSize));
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.fileChannelHandle.close();
    }

    @Override
    public synchronized FileChannel position(long newPosition) throws IOException {
        this.position = newPosition;
        return this;
    }

    @Override
    public synchronized int read(ByteBuffer target) throws IOException {
        int bytesRead = this.read(target, this.position);
        this.position += (long)Math.max(0, bytesRead);
        return bytesRead;
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        int bytesWritten = this.write(src, this.position);
        this.position += (long)Math.max(0, bytesWritten);
        return bytesWritten;
    }

    @Override
    public synchronized long position() {
        return this.position;
    }

    @Override
    @Deprecated
    @Contract(value="_, _, _ -> fail")
    public long read(ByteBuffer[] targets, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet: no use");
    }

    @Override
    @Deprecated
    @Contract(value="_, _, _ -> fail")
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet: no use");
    }

    @Override
    @Deprecated
    @Contract(value="_, _, _ -> fail")
    public long transferTo(long position, long count2, WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet: no use");
    }

    @Override
    @Deprecated
    @Contract(value="_, _, _ -> fail")
    public long transferFrom(ReadableByteChannel src, long position, long count2) throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet: no use");
    }

    @Override
    @Deprecated
    @Contract(value="_, _, _ -> fail")
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet: no use");
    }

    @Override
    @Deprecated
    @Contract(value="_, _, _ -> fail")
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet: no use");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openOptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/ResilientFileChannel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

