/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0001\u001a \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\f\u0010\u0007\u001a\u00020\u0002*\u00020\u0002H\u0007\u001a\f\u0010\b\u001a\u00020\u0002*\u00020\u0002H\u0007\u001a\u0014\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0001H\u0007\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u0001\u00a8\u0006\u000b"}, d2={"toCanonicalPath", "", "Ljava/nio/file/Path;", "getResolvedPath", "relativePath", "relativizeToClosestAncestor", "Lkotlin/Pair;", "findOrCreateFile", "findOrCreateDirectory", "toNioPath", "toNioPathOrNull", "intellij.platform.util"})
@JvmName(name="NioPathUtil")
public final class NioPathUtil {
    @NotNull
    public static final String toCanonicalPath(@NotNull Path $this$toCanonicalPath) {
        Intrinsics.checkNotNullParameter($this$toCanonicalPath, "<this>");
        Path path = $this$toCanonicalPath.normalize();
        Intrinsics.checkNotNullExpressionValue(path, "normalize(...)");
        return PathsKt.getInvariantSeparatorsPathString(path);
    }

    @NotNull
    public static final Path getResolvedPath(@NotNull Path $this$getResolvedPath, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$getResolvedPath, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Path path = $this$getResolvedPath.resolve(relativePath).normalize();
        Intrinsics.checkNotNullExpressionValue(path, "normalize(...)");
        return path;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Pair<Path, Path> relativizeToClosestAncestor(@NotNull Path $this$relativizeToClosestAncestor, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$relativizeToClosestAncestor, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Path normalizedPath = NioPathUtil.getResolvedPath($this$relativizeToClosestAncestor, relativePath);
        Path path = FileUtil.findAncestor($this$relativizeToClosestAncestor, normalizedPath);
        if (path == null) {
            boolean bl = false;
            String string = StringsKt.trimMargin$default("\n      |Cannot resolve normalized base path for: " + normalizedPath + "\n      |  basePath = " + $this$relativizeToClosestAncestor + "\n      |  relativePath = " + relativePath + "\n    ", null, 1, null);
            throw new IllegalStateException(string.toString());
        }
        Path normalizedBasePath = path;
        Path normalizedRelativePath = normalizedBasePath.relativize(normalizedPath);
        return TuplesKt.to(normalizedBasePath, normalizedRelativePath);
    }

    @ApiStatus.Internal
    @NotNull
    public static final Path findOrCreateFile(@NotNull Path $this$findOrCreateFile) {
        Path path;
        Intrinsics.checkNotNullParameter($this$findOrCreateFile, "<this>");
        Path path2 = $this$findOrCreateFile.getParent();
        if (path2 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "createDirectories(...)");
        } else {
            path = null;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$findOrCreateFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue(Files.createFile($this$findOrCreateFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createFile(...)");
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile($this$findOrCreateFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new IOException("Expected file instead of directory: " + $this$findOrCreateFile);
        }
        return $this$findOrCreateFile;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Path findOrCreateDirectory(@NotNull Path $this$findOrCreateDirectory) {
        Intrinsics.checkNotNullParameter($this$findOrCreateDirectory, "<this>");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue(Files.createDirectories($this$findOrCreateDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(...)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory($this$findOrCreateDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Expected directory instead of file: " + $this$findOrCreateDirectory);
        }
        return $this$findOrCreateDirectory;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Path findOrCreateFile(@NotNull Path $this$findOrCreateFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findOrCreateFile, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        return NioPathUtil.findOrCreateFile(NioPathUtil.getResolvedPath($this$findOrCreateFile, relativePath));
    }

    @ApiStatus.Internal
    @NotNull
    public static final Path findOrCreateDirectory(@NotNull Path $this$findOrCreateDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findOrCreateDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        return NioPathUtil.findOrCreateDirectory(NioPathUtil.getResolvedPath($this$findOrCreateDirectory, relativePath));
    }

    @Deprecated(message="Do not use", level=DeprecationLevel.ERROR)
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Internal
    @NotNull
    public static final Path toNioPath(@NotNull String $this$toNioPath) {
        Intrinsics.checkNotNullParameter($this$toNioPath, "<this>");
        Path path = Paths.get(FileUtilRt.toSystemDependentName((String)$this$toNioPath), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        return path;
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull String $this$toNioPathOrNull) {
        Path path;
        Intrinsics.checkNotNullParameter($this$toNioPathOrNull, "<this>");
        try {
            path = Paths.get(FileUtilRt.toSystemDependentName((String)$this$toNioPathOrNull), new String[0]);
        }
        catch (InvalidPathException ex) {
            path = null;
        }
        return path;
    }
}

