/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/project/ProjectCoreUtil;", "", "<init>", "()V", "theOnlyProject", "Lcom/intellij/openapi/project/Project;", "isProjectOrWorkspaceFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOrParent", "fileName", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "theOnlyOpenProject", "updateInternalTheOnlyProjectFieldTemporarily", "", "project", "intellij.platform.core"})
public final class ProjectCoreUtil {
    @NotNull
    public static final ProjectCoreUtil INSTANCE = new ProjectCoreUtil();
    @Nullable
    private static volatile Project theOnlyProject;

    private ProjectCoreUtil() {
    }

    @JvmStatic
    public static final boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        CharSequence charSequence = file.getNameSequence();
        Intrinsics.checkNotNullExpressionValue(charSequence, "getNameSequence(...)");
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file, charSequence);
    }

    @JvmStatic
    public static final boolean isProjectOrWorkspaceFile(@NotNull VirtualFile fileOrParent, @NotNull CharSequence fileName) {
        Intrinsics.checkNotNullParameter(fileOrParent, "fileOrParent");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        Intrinsics.checkNotNullExpressionValue(fileType, "getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        return ProjectCoreUtil.isProjectOrWorkspaceFile(fileOrParent, fileType2);
    }

    @JvmStatic
    public static final boolean isProjectOrWorkspaceFile(@NotNull VirtualFile fileOrParent, @Nullable FileType fileType) {
        Intrinsics.checkNotNullParameter(fileOrParent, "fileOrParent");
        return fileType instanceof InternalFileType || VfsUtilCore.findContainingDirectory(fileOrParent, ".idea") != null;
    }

    @JvmStatic
    @Deprecated(message="Please use {@link com.intellij.psi.PsiElement#getProject()} or {@link com.intellij.openapi.project.ProjectManager#getOpenProjects()} instead.")
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Internal
    @Nullable
    public static final Project theOnlyOpenProject() {
        return theOnlyProject;
    }

    @ApiStatus.Internal
    public final void updateInternalTheOnlyProjectFieldTemporarily(@Nullable Project project) {
        theOnlyProject = project;
    }
}

