/*
 * Decompiled with CFR 0.152.
 */
package coil3;

import coil3.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0013\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\""}, d2={"Lcoil3/BitmapImage;", "Lcoil3/Image;", "bitmap", "Lorg/jetbrains/skia/Bitmap;", "Lcoil3/Bitmap;", "shareable", "", "<init>", "(Lorg/jetbrains/skia/Bitmap;Z)V", "getBitmap", "()Lorg/jetbrains/skia/Bitmap;", "getShareable", "()Z", "size", "", "getSize", "()J", "width", "", "getWidth", "()I", "height", "getHeight", "draw", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcoil3/Canvas;", "equals", "other", "", "hashCode", "toString", "", "coil-core"})
public final class BitmapImage
implements Image {
    @NotNull
    private final Bitmap bitmap;
    private final boolean shareable;

    public BitmapImage(@NotNull Bitmap bitmap, boolean shareable) {
        this.bitmap = bitmap;
        this.shareable = shareable;
    }

    @NotNull
    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public boolean getShareable() {
        return this.shareable;
    }

    @Override
    public long getSize() {
        long size2 = this.bitmap.getImageInfo().computeMinByteSize();
        if (size2 <= 0L) {
            size2 = 4L * (long)this.bitmap.getWidth() * (long)this.bitmap.getHeight();
        }
        return RangesKt.coerceAtLeast((long)size2, (long)0L);
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        canvas.writePixels(this.bitmap, 0, 0);
    }

    public int hashCode() {
        int result2 = this.bitmap.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.shareable);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BitmapImage)) {
            return false;
        }
        BitmapImage bitmapImage = (BitmapImage)other;
        if (!Intrinsics.areEqual((Object)this.bitmap, (Object)bitmapImage.bitmap)) {
            return false;
        }
        return this.shareable == bitmapImage.shareable;
    }

    @NotNull
    public String toString() {
        return "BitmapImage(bitmap=" + this.bitmap + ", shareable=" + this.shareable + ')';
    }
}

