/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.visibility.EntryPointWithVisibilityLevel;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class JUnitEntryPoint
extends EntryPointWithVisibilityLevel {
    private static final Collection<String> FIELD_ANNOTATIONS = Arrays.asList("org.junit.runners.Parameterized.Parameter", "org.junit.jupiter.api.extension.RegisterExtension");
    public boolean ADD_JUNIT_TO_ENTRIES = true;

    @NotNull
    public String getDisplayName() {
        String string = JUnitBundle.message("unused.declaration.junit.test.entry.point", new Object[0]);
        if (string == null) {
            JUnitEntryPoint.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            JUnitEntryPoint.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            JUnitEntryPoint.$$$reportNull$$$0(2);
        }
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JUnitEntryPoint.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof PsiClass) {
            PsiClass aClass = (PsiClass)psiElement;
            if (JUnitUtil.isTestClass((PsiClass)aClass, (boolean)false, (boolean)true)) {
                boolean isJUnit5 = JUnitUtil.isJUnit5((PsiElement)aClass);
                if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (!isJUnit5 ? 1 : 0) != 0, (boolean)true)) {
                    PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)aClass, PsiClass.class);
                    if (topLevelClass != null && PsiClassUtil.isRunnableClass((PsiClass)topLevelClass, (!isJUnit5 ? 1 : 0) != 0, (boolean)true)) {
                        return true;
                    }
                    CommonProcessors.FindProcessor<PsiClass> findProcessor = new CommonProcessors.FindProcessor<PsiClass>(){

                        protected boolean accept(PsiClass psiClass) {
                            return !psiClass.hasModifierProperty("abstract");
                        }
                    };
                    return !ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)findProcessor) && findProcessor.isFound();
                }
                return true;
            }
        } else if (psiElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            if (method.isConstructor() && method.getParameterList().isEmpty()) {
                PsiClass aClass = method.getContainingClass();
                return aClass != null && JUnitUtil.isTestClass((PsiClass)aClass);
            }
            if (JUnitUtil.isTestMethodOrConfig((PsiMethod)method)) {
                return true;
            }
        } else if (psiElement instanceof PsiField) {
            return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiField)psiElement), FIELD_ANNOTATIONS, (int)0);
        }
        return false;
    }

    public int getMinVisibilityLevel(PsiMember member) {
        PsiClass container = null;
        if (member instanceof PsiClass) {
            container = (PsiClass)member;
        } else if (member instanceof PsiMethod) {
            container = member.getContainingClass();
        }
        if (container != null && JUnitUtil.isJUnit5TestClass((PsiClass)container, (boolean)false) && !JUnitUtil.isJUnit4TestClass((PsiClass)container, (boolean)false) && !JUnitUtil.isJUnit3TestClass((PsiClass)container)) {
            return 2;
        }
        if (member instanceof PsiField && AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)"org.junit.jupiter.api.extension.RegisterExtension", (int)0)) {
            return 2;
        }
        return -1;
    }

    public String getTitle() {
        return JUnitBundle.message("junit.entry.point.suggest.package.private.visibility.junit5", new Object[0]);
    }

    public String getId() {
        return "junit";
    }

    public boolean isSelected() {
        return this.ADD_JUNIT_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_JUNIT_TO_ENTRIES = selected;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.ADD_JUNIT_TO_ENTRIES) {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
    }

    public String[] getIgnoreAnnotations() {
        return new String[]{"org.junit.Rule", "org.junit.ClassRule", "org.junit.experimental.theories.DataPoint", "org.junit.experimental.theories.DataPoints"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit2/inspection/JUnitEntryPoint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit2/inspection/JUnitEntryPoint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

