/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.tree;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaHighlightingSessionStatisticsCollector;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import com.jetbrains.jsonSchema.impl.tree.Operation;
import com.jetbrains.jsonSchema.impl.tree.ProcessDefinitionsOperation;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OneOfOperation
extends Operation {
    private final JsonSchemaService myService;

    protected OneOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service, @Nullable JsonSchemaNodeExpansionRequest expansionRequest) {
        if (sourceNode == null) {
            OneOfOperation.$$$reportNull$$$0(0);
        }
        super(sourceNode, expansionRequest);
        this.myService = service;
    }

    @Override
    public void map(@NotNull Set<JsonSchemaObject> visited) {
        if (visited == null) {
            OneOfOperation.$$$reportNull$$$0(1);
        }
        JsonSchemaHighlightingSessionStatisticsCollector.getInstance().reportSchemaUsageFeature(JsonSchemaFusCountedFeature.OneOfExpanded);
        List<? extends JsonSchemaObject> oneOf = this.mySourceNode.getOneOf();
        assert (oneOf != null);
        this.myChildOperations.addAll(ContainerUtil.map(oneOf, sourceNode -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService, this.myExpansionRequest)));
    }

    @Override
    public void reduce() {
        SmartList oneOf = new SmartList();
        for (Operation op : this.myChildOperations) {
            if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
            oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, op.myAnyOfGroup));
            oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, OneOfOperation.mergeOneOf(op)));
        }
        this.myOneOfGroup.add(oneOf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/tree/OneOfOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

