/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyNamePattern {
    @NotNull
    public final String myPattern;
    @Nullable
    public final Pattern myCompiledPattern;
    @Nullable
    public final String myPatternError;
    @NotNull
    public final Map<String, Boolean> myValuePatternCache;

    public PropertyNamePattern(@NotNull String pattern) {
        if (pattern == null) {
            PropertyNamePattern.$$$reportNull$$$0(0);
        }
        this.myPattern = StringUtil.unescapeBackSlashes((String)pattern);
        Pair<Pattern, String> pair = JsonSchemaObjectReadingUtils.compilePattern(pattern);
        this.myPatternError = (String)pair.getSecond();
        this.myCompiledPattern = (Pattern)pair.getFirst();
        this.myValuePatternCache = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
    }

    @Nullable
    public String getPatternError() {
        return this.myPatternError;
    }

    public boolean checkByPattern(@NotNull String name) {
        if (name == null) {
            PropertyNamePattern.$$$reportNull$$$0(1);
        }
        if (this.myPatternError != null) {
            return true;
        }
        if (Boolean.TRUE.equals(this.myValuePatternCache.get(name))) {
            return true;
        }
        assert (this.myCompiledPattern != null);
        boolean matches = JsonSchemaObjectReadingUtils.matchPattern(this.myCompiledPattern, name);
        this.myValuePatternCache.put(name, matches);
        return matches;
    }

    @NotNull
    public String getPattern() {
        String string = this.myPattern;
        if (string == null) {
            PropertyNamePattern.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/PropertyNamePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/PropertyNamePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkByPattern";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

