/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.dce;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.dce.DceDumpNameCache;
import org.jetbrains.kotlin.ir.backend.js.dce.IrDeclarationDumpInfo;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a&\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0001H\u0000\u00a8\u0006\f"}, d2={"fqNameForDceDump", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "dumpDeclarationIrSizesIfNeed", "", "path", "allModules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dceDumpNameCache", "Lorg/jetbrains/kotlin/ir/backend/js/dce/DceDumpNameCache;", "removeQuotes", "backend.js"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/ir/backend/js/dce/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1869#2,2:91\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/ir/backend/js/dce/UtilsKt\n*L\n40#1:91,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String fqNameForDceDump(@NotNull IrDeclaration $this$fqNameForDceDump) {
        Intrinsics.checkNotNullParameter($this$fqNameForDceDump, "<this>");
        Object object = $this$fqNameForDceDump instanceof IrDeclarationWithName ? (IrDeclarationWithName)$this$fqNameForDceDump : null;
        if (object == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null || (object = ((FqName)object).asString()) == null) {
            object = "<unknown>";
        }
        Object fqn = object;
        String signature = $this$fqNameForDceDump instanceof IrFunction ? CollectionsKt.joinToString$default(IrUtilsKt.getNonDispatchParameters((IrFunction)$this$fqNameForDceDump), null, "(", ")", 0, null, UtilsKt::fqNameForDceDump$lambda$0, 25, null) : "";
        String synthetic = Intrinsics.areEqual($this$fqNameForDceDump.getOrigin(), PrimaryConstructorLowering.Companion.getSYNTHETIC_PRIMARY_CONSTRUCTOR()) ? "[synthetic]" : "";
        return (String)fqn + signature + synthetic;
    }

    public static final void dumpDeclarationIrSizesIfNeed(@Nullable String path, @NotNull List<? extends IrModuleFragment> allModules, @NotNull DceDumpNameCache dceDumpNameCache) {
        List list;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(allModules, "allModules");
        Intrinsics.checkNotNullParameter(dceDumpNameCache, "dceDumpNameCache");
        if (path == null) {
            return;
        }
        LinkedHashSet<IrDeclarationDumpInfo> declarations2 = new LinkedHashSet<IrDeclarationDumpInfo>();
        Iterable $this$forEach$iv = allModules;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv2;
            boolean bl = false;
            IrVisitorsKt.acceptChildrenVoid((IrElement)it, new IrVisitorVoid(declarations2, dceDumpNameCache){
                final /* synthetic */ LinkedHashSet<IrDeclarationDumpInfo> $declarations;
                final /* synthetic */ DceDumpNameCache $dceDumpNameCache;
                {
                    this.$declarations = $declarations;
                    this.$dceDumpNameCache = $dceDumpNameCache;
                }

                public void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitDeclaration(IrDeclarationBase declaration) {
                    String type;
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Object object = declaration;
                    String string = type = object instanceof IrFunction ? "function" : (object instanceof IrProperty ? "property" : (object instanceof IrField ? "field" : (object instanceof IrAnonymousInitializer ? "anonymous initializer" : null)));
                    if (string != null) {
                        object = string;
                        LinkedHashSet<IrDeclarationDumpInfo> linkedHashSet = this.$declarations;
                        DceDumpNameCache dceDumpNameCache = this.$dceDumpNameCache;
                        Object it = object;
                        boolean bl = false;
                        linkedHashSet.add(new IrDeclarationDumpInfo(UtilsKt.removeQuotes(dceDumpNameCache.getOrPut(declaration)), (String)it, DumpKotlinLikeKt.dumpKotlinLike$default(declaration, null, 1, null).length()));
                    }
                    super.visitDeclaration(declaration);
                }
            });
        }
        File out = new File(path);
        String string = FilesKt.getExtension(out);
        if (Intrinsics.areEqual(string, "json")) {
            element$iv2 = new String[]{"{\n", "\n}", ",\n", "    "};
            list = CollectionsKt.listOf(element$iv2);
        } else if (Intrinsics.areEqual(string, "js")) {
            element$iv2 = new String[]{"export const kotlinDeclarationsSize = {\n", "\n};\n", ",\n", "    "};
            list = CollectionsKt.listOf(element$iv2);
        } else {
            element$iv2 = new String[]{"", "", "\n", ""};
            list = CollectionsKt.listOf(element$iv2);
        }
        List list2 = list;
        String prefix = (String)list2.get(0);
        String postfix = (String)list2.get(1);
        String separator = (String)list2.get(2);
        String indent = (String)list2.get(3);
        String value2 = CollectionsKt.joinToString$default(declarations2, separator, prefix, postfix, 0, null, arg_0 -> UtilsKt.dumpDeclarationIrSizesIfNeed$lambda$2(indent, arg_0), 24, null);
        FilesKt.writeText$default(out, value2, null, 2, null);
    }

    @NotNull
    public static final String removeQuotes(@NotNull String $this$removeQuotes) {
        Intrinsics.checkNotNullParameter($this$removeQuotes, "<this>");
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$removeQuotes, "\"", "", false, 4, null), "'", "", false, 4, null), "\\", "\\\\", false, 4, null);
    }

    private static final CharSequence fqNameForDceDump$lambda$0(IrValueParameter it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DumpKotlinLikeKt.dumpKotlinLike(it.getType());
    }

    private static final CharSequence dumpDeclarationIrSizesIfNeed$lambda$2(String $indent, IrDeclarationDumpInfo declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return StringsKt.trimMargin$default($indent + '\"' + declaration.getFqName() + "\": {\n                |" + $indent + $indent + "\"size\": " + declaration.getSize() + ",\n                |" + $indent + $indent + "\"type\": \"" + declaration.getType() + "\"\n                |" + $indent + "}\n            ", null, 1, null);
    }
}

