/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.trace.TraceFlags;

final class ImmutableTraceFlags
implements TraceFlags {
    private static final ImmutableTraceFlags[] INSTANCES = ImmutableTraceFlags.buildInstances();
    static final ImmutableTraceFlags DEFAULT = ImmutableTraceFlags.fromByte((byte)0);
    static final ImmutableTraceFlags SAMPLED = ImmutableTraceFlags.fromByte((byte)1);
    private final String hexRep;
    private final byte byteRep;

    static ImmutableTraceFlags fromByte(byte traceFlagsByte) {
        return INSTANCES[traceFlagsByte & 0xFF];
    }

    private static ImmutableTraceFlags[] buildInstances() {
        ImmutableTraceFlags[] instances = new ImmutableTraceFlags[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            instances[i2] = new ImmutableTraceFlags((byte)i2);
        }
        return instances;
    }

    private ImmutableTraceFlags(byte byteRep) {
        char[] result2 = new char[2];
        OtelEncodingUtils.byteToBase16(byteRep, result2, 0);
        this.hexRep = new String(result2);
        this.byteRep = byteRep;
    }

    public String asHex() {
        return this.hexRep;
    }

    public String toString() {
        return this.asHex();
    }
}

