/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import com.intellij.util.io.pagecache.PageUnsafe;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class PageImpl
implements PageUnsafe,
Flushable {
    private static final AtomicIntegerFieldUpdater<PageImpl> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PageImpl.class, "statePacked");
    private static final AtomicIntegerFieldUpdater<PageImpl> TOKENS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PageImpl.class, "tokensOfUsefulness");
    private final int pageSize;
    private final int pageIndex;
    private final transient long offsetInFile;
    private volatile int statePacked;
    private volatile Object auxDebugData;
    protected ByteBuffer data;
    private volatile int tokensOfUsefulness;
    private int tokensOfUsefulnessLocal;

    public int pageSize() {
        return this.pageSize;
    }

    public int pageIndex() {
        return this.pageIndex;
    }

    public boolean isUsable() {
        return this.inState(2);
    }

    public boolean isAboutToUnmap() {
        return this.inState(3);
    }

    public boolean isPreTombstone() {
        return this.inState(4);
    }

    public boolean isTombstone() {
        return this.inState(5);
    }

    public boolean inState(int expectedState) {
        return PageImpl.unpackState(this.statePacked) == expectedState;
    }

    public int usageCount() {
        return PageImpl.unpackUsageCount(this.statePacked);
    }

    public void release() {
        int usageCount;
        int newUsageCount;
        int state;
        int newPackedState;
        int packedState;
        do {
            packedState = this.statePacked;
            state = PageImpl.unpackState(packedState);
            usageCount = PageImpl.unpackUsageCount(packedState);
            if (state != 2 && state != 3) {
                throw new AssertionError((Object)("Bug: .release() must be called on {USABLE|ABOUT_TO_UNMAP} page only, but .state[=" + state + "]"));
            }
            if (usageCount == 0) {
                throw new AssertionError((Object)"Bug: can't .release() page with usageCount=0 -- unpaired .acquire()/.release() calls?");
            }
        } while (!STATE_UPDATER.compareAndSet(this, packedState, newPackedState = PageImpl.packState(state, newUsageCount = usageCount - 1)));
        this.addTokensOfUsefulness(8 * usageCount);
    }

    public boolean tryMoveTowardsPreTombstone(boolean entombYoung) {
        int state;
        block8: while (true) {
            int packedState = this.statePacked;
            state = PageImpl.unpackState(packedState);
            int usageCount = PageImpl.unpackUsageCount(packedState);
            switch (state) {
                case 0: {
                    int newPackedState;
                    return entombYoung && STATE_UPDATER.compareAndSet(this, packedState, newPackedState = PageImpl.packState(4, 0));
                }
                case 1: {
                    return false;
                }
                case 2: {
                    int newPackedState;
                    if (usageCount <= 0) continue block8;
                    return false;
                    if (STATE_UPDATER.compareAndSet(this, packedState, newPackedState = PageImpl.packState(3, 0))) continue block8;
                    return false;
                }
                case 3: {
                    if (usageCount > 0) {
                        throw new AssertionError((Object)("Page[ABOUT_TO_UNMAP].usageCount=" + usageCount + " -- must be 0. " + this));
                    }
                    int newPackedState = PageImpl.packState(4, 0);
                    if (STATE_UPDATER.compareAndSet(this, packedState, newPackedState)) {
                        return true;
                    }
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
            }
            break;
        }
        throw new AssertionError((Object)("Code bug: unknown state " + state + ": " + this));
    }

    public void entomb() {
        if (this.isDirty()) {
            throw new AssertionError((Object)("Bug: page must be !dirty to be TOMBSTONE-ed, but: " + this));
        }
        int packedState = this.statePacked;
        int state = PageImpl.unpackState(packedState);
        int usageCount = PageImpl.unpackUsageCount(packedState);
        if (usageCount > 0) {
            throw new AssertionError((Object)("Bug: page.usageCount(=" + usageCount + ") must be 0. page: " + this));
        }
        if (state != 4) {
            throw new AssertionError((Object)("Bug: page.state(=" + state + ") be PRE_TOMBSTONE. " + this));
        }
        int newPackedState = PageImpl.packState(5, 0);
        if (!STATE_UPDATER.compareAndSet(this, packedState, newPackedState)) {
            throw new AssertionError((Object)("Bug: somebody interferes with PRE_TOMBSTONE->TOMBSTONE transition. " + this));
        }
    }

    public ByteBuffer detachTombstoneBuffer() {
        if (!this.isPreTombstone()) {
            throw new AssertionError((Object)("Bug: only PRE_TOMBSTONES could detach buffer. " + this));
        }
        ByteBuffer buffer = this.data;
        if (buffer == null) {
            throw new AssertionError((Object)("Bug: buffer already detached, .data is null. " + this));
        }
        this.data = null;
        return buffer;
    }

    private static int packState(int state, int newUsageCount) {
        return state << 24 | newUsageCount;
    }

    private static int unpackUsageCount(int packedState) {
        return packedState & 0xFFFFFF;
    }

    private static int unpackState(int packedState) {
        return packedState >> 24;
    }

    public abstract boolean isDirty();

    @Override
    public abstract void flush() throws IOException;

    public abstract boolean tryFlush() throws IOException;

    @Override
    public void close() {
        this.release();
    }

    public int addTokensOfUsefulness(int tokensToAdd) {
        int newTokens;
        int tokens;
        assert (tokensToAdd >= 0) : "tokensToAdd(" + tokensToAdd + ") must be >=0";
        do {
            if ((newTokens = (tokens = this.tokensOfUsefulness) + tokensToAdd) >= 0) continue;
            newTokens = Integer.MAX_VALUE;
        } while (!TOKENS_UPDATER.compareAndSet(this, tokens, newTokens));
        return newTokens;
    }

    public int decayTokensOfUsefulness(int numerator, int denominator) {
        int decayedTokens;
        int tokens;
        assert (numerator >= 0) : "numerator(" + numerator + ") must be >=0";
        assert (denominator > 0) : "denominator(" + denominator + ") must be >0";
        while (!TOKENS_UPDATER.compareAndSet(this, tokens = this.tokensOfUsefulness, decayedTokens = tokens * numerator / denominator)) {
        }
        return decayedTokens;
    }

    public int tokensOfUsefulness() {
        return this.tokensOfUsefulness;
    }

    public int localTokensOfUsefulness() {
        return this.tokensOfUsefulnessLocal;
    }

    public void updateLocalTokensOfUsefulness(int tokensOfUsefulness) {
        this.tokensOfUsefulnessLocal = tokensOfUsefulness;
    }

    public ByteBuffer pageBufferUnchecked() {
        return this.data;
    }

    public String toString() {
        int packedState = this.statePacked;
        return "Page[#" + this.pageIndex + ", size: " + this.pageSize + "b, offsetInFile: " + this.offsetInFile + "b]{state: " + PageImpl.unpackState(packedState) + ", inUse: " + PageImpl.unpackUsageCount(packedState) + "}" + (this.auxDebugData != null ? ", aux: " + this.auxDebugData : "");
    }
}

