/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.csv.ui.CsvFormatsSettingsUI;
import com.intellij.database.csv.ui.CsvFormatsUI;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.csv.ui.preview.TableAndTextCsvFormatPreview;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatsComponent
implements ConfigurableUi<CsvFormatsSettings>,
Disposable {
    private final JPanel myPanel;
    private final CsvFormatsUI myFormatsEditor;

    public CsvFormatsComponent() {
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        this.myFormatsEditor = new CsvFormatsSettingsUI(this);
        this.myPanel = new FormatsListAndPreviewPanel(this.myFormatsEditor, new TableAndTextCsvFormatPreview(project, this));
    }

    public CsvFormatsComponent(@NotNull CsvFormatPreview preview) {
        if (preview == null) {
            CsvFormatsComponent.$$$reportNull$$$0(0);
        }
        this.myFormatsEditor = new CsvFormatsSettingsUI(this);
        this.myPanel = new FormatsListAndPreviewPanel(this.myFormatsEditor, preview);
    }

    public void reset(@NotNull CsvFormatsSettings settings) {
        if (settings == null) {
            CsvFormatsComponent.$$$reportNull$$$0(1);
        }
        this.reset(settings, null);
    }

    public void reset(@NotNull CsvFormatsSettings settings, @Nullable String name) {
        if (settings == null) {
            CsvFormatsComponent.$$$reportNull$$$0(2);
        }
        List formats = settings.getCsvFormats();
        this.reset(formats, name);
    }

    public void reset(@NotNull List<CsvFormat> formats, @Nullable String name) {
        if (formats == null) {
            CsvFormatsComponent.$$$reportNull$$$0(3);
        }
        this.myFormatsEditor.reset(formats, name);
    }

    @Nullable
    public CsvFormat select(@Nullable CsvFormat format) {
        return this.myFormatsEditor.select(format);
    }

    public boolean isModified(@NotNull CsvFormatsSettings settings) {
        List<CsvFormat> formatsInEditor;
        List formats;
        if (settings == null) {
            CsvFormatsComponent.$$$reportNull$$$0(4);
        }
        return !(formats = settings.getCsvFormats()).equals(formatsInEditor = this.getFormats());
    }

    public void apply(@NotNull CsvFormatsSettings settings) {
        if (settings == null) {
            CsvFormatsComponent.$$$reportNull$$$0(5);
        }
        settings.setCsvFormats(this.getFormats());
        settings.fireChanged();
    }

    @NotNull
    public List<CsvFormat> getFormats() {
        List<CsvFormat> list = this.myFormatsEditor.getFormats();
        if (list == null) {
            CsvFormatsComponent.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public CsvFormat getSelectedFormat() {
        return this.myFormatsEditor.getSelectedFormat();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CsvFormatsComponent.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/CsvFormatsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/CsvFormatsComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormats";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

