#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 graphviz
version:              2999.20.2.1
visibility:           public
id:                   graphviz-2999.20.2.1-LWC6Dem6wMcJCmu36GXLj6
key:                  graphviz-2999.20.2.1-LWC6Dem6wMcJCmu36GXLj6
license:              BSD-3-Clause
copyright:            Matthew Sackman, Ivan Lazar Miljenovic
maintainer:           Daniel Casanueva (coding `at` danielcasanueva.eu)
author:               Matthew Sackman, Ivan Lazar Miljenovic
synopsis:             Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.

    Main features of the graphviz library include:

    * Almost complete coverage of all Graphviz attributes and syntax.

    * Support for specifying clusters.

    * The ability to use a custom node type.

    * Functions for running a Graphviz layout tool with all specified
    output types.

    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).

    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.

    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.

category:             Graphs, Graphics
abi:                  5124e1c81cf3f41d2051314b039b324f
exposed:              True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic

hidden-modules:
    Data.GraphViz.Algorithms.Clustering Data.GraphViz.Attributes.Arrows
    Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
    Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
    Data.GraphViz.Types.State

import-dirs:          /usr/lib/ghc-9.6.6/site-local/graphviz-2999.20.2.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/graphviz-2999.20.2.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/graphviz-2999.20.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-graphviz
hs-libraries:         HSgraphviz-2999.20.2.1-LWC6Dem6wMcJCmu36GXLj6
depends:
    base-4.18.2.1 bytestring-0.11.5.3
    colour-2.3.6-AUxOwa0Re963ovR5vIqIeF containers-0.6.7
    directory-1.3.8.5 dlist-1.0-B7D1vsARFiIHVaGk5CGbYO
    fgl-5.8.3.0-3iunPv9ipl7m3Y8VbIChH filepath-1.4.300.1 mtl-2.3.1
    polyparse-1.13.1-GNSrxCypyqMZdcZAjLboq process-1.6.19.0
    temporary-1.3-7FXkQQKerYU7UfmRyKNwo9 text-2.0.2
    wl-pprint-text-1.2.0.2-5YZxK5KOTfOHzkZyfFB7rt

haddock-interfaces:   /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html:         /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

