import '@grafana/data';
import { DataSourceWithBackend } from '@grafana/runtime';
import { c as chanceExports } from '../../_virtual/chance.js';
import { mockDataSourcePluginMeta } from './Plugin.js';
import { generateBoolean, undefinedOr } from './utils.js';

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
class DatasourceMock extends DataSourceWithBackend {
  constructor() {
    super(...arguments);
    // DataSourceWithBackend
    __publicField(this, "query", jest.fn());
    __publicField(this, "filterQuery", undefinedOr(generateBoolean));
    __publicField(this, "applyTemplateVariables", jest.fn());
    __publicField(this, "getResource", jest.fn());
    __publicField(this, "postResource", jest.fn());
    __publicField(this, "callHealthCheck", jest.fn());
    __publicField(this, "testDatasource", jest.fn());
    // DataSourceApi
    __publicField(this, "uid", chanceExports.Chance().guid());
    __publicField(this, "name", chanceExports.Chance().word());
    __publicField(this, "id", 1);
    __publicField(this, "type", chanceExports.Chance().word());
    __publicField(this, "interval", chanceExports.Chance().word());
    __publicField(this, "importQueries", jest.fn());
    __publicField(this, "init", jest.fn());
    __publicField(this, "getQueryHints", jest.fn().mockReturnValue([mockQueryHint()]));
    __publicField(this, "getQueryDisplayText", jest.fn().mockReturnValue(chanceExports.Chance().word()));
    __publicField(this, "metricFindQuery", jest.fn());
    __publicField(this, "getTagKeys", jest.fn());
    __publicField(this, "getTagValues", jest.fn());
    __publicField(this, "components", {});
    __publicField(this, "meta", mockDataSourcePluginMeta());
    __publicField(this, "targetContainsTemplate", jest.fn());
    __publicField(this, "modifyQuery", jest.fn());
    __publicField(this, "getHighlighterExpression", jest.fn());
    __publicField(this, "languageProvider", jest.fn());
    __publicField(this, "getVersion", jest.fn());
    __publicField(this, "interpolateVariablesInQueries", jest.fn());
    __publicField(this, "annotations", {});
    __publicField(this, "annotationQuery", jest.fn());
    __publicField(this, "streamOptionsProvider", jest.fn());
    __publicField(this, "getRef", jest.fn());
    __publicField(this, "getRequestHeaders", jest.fn());
  }
}
const mockDatasource = () => new DatasourceMock(mockDatasourceInstanceSettings());
const mockQueryHint = () => ({
  type: chanceExports.Chance().word(),
  label: chanceExports.Chance().word(),
  fix: {
    label: chanceExports.Chance().word(),
    action: {
      type: chanceExports.Chance().word(),
      query: chanceExports.Chance().word(),
      preventSubmit: generateBoolean()
    }
  }
});
const mockDatasourceInstanceSettings = () => ({
  id: chanceExports.Chance().integer(),
  uid: chanceExports.Chance().word(),
  type: chanceExports.Chance().word(),
  name: chanceExports.Chance().word(),
  meta: mockDataSourcePluginMeta(),
  url: chanceExports.Chance().word(),
  jsonData: {},
  username: chanceExports.Chance().word(),
  password: chanceExports.Chance().word(),
  database: chanceExports.Chance().word(),
  basicAuth: chanceExports.Chance().word(),
  withCredentials: generateBoolean(),
  access: chanceExports.Chance().pickone(["direct", "proxy"]),
  readOnly: false
});

export { mockDatasource, mockDatasourceInstanceSettings };
//# sourceMappingURL=Datasource.js.map
