import { useState, useEffect } from 'react';

const DEFAULT_DELAY = 275;
const useDebounce = (value, delay = DEFAULT_DELAY) => {
  const [debouncedValue, setDebouncedValue] = useState(value);
  useEffect(() => {
    const handler = setTimeout(() => {
      setDebouncedValue(value);
    }, delay);
    return () => {
      clearTimeout(handler);
    };
  }, [value]);
  return debouncedValue;
};

export { DEFAULT_DELAY, useDebounce };
//# sourceMappingURL=useDebounce.js.map
