import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { uniqueId } from 'lodash';
import { useRef } from 'react';
import '@grafana/data';
import { useStyles2, Switch } from '@grafana/ui';
import '../../QueryEditor/types.js';
import '../../QueryEditor/EditorList.js';
import { EditorStack } from '../../QueryEditor/EditorStack.js';
import '../../QueryEditor/Space.js';
import 'react-use';
import '../../QueryEditor/QueryHeader.js';
import 'react-virtualized-auto-sizer';
import 'sql-formatter-plus';
import '../../SQLEditor/standardSql/language.js';
import 'uuid';
import '@grafana/runtime';
import '../../SQLEditor/utils/debugger.js';
import '../../SQLEditor/standardSql/macros.js';
import '../../QueryEditor/visual-query-builder/AwesomeQueryBuilder.js';
import '../../QueryEditor/visual-query-builder/WhereRow.js';
import '../../QueryEditor/visual-query-builder/EditorField.js';
import 'rxjs';
import 'rxjs/operators';

function QueryHeaderSwitch({ label, ...inputProps }) {
  const dashedLabel = label.replace(" ", "-");
  const switchIdRef = useRef(uniqueId(`switch-${dashedLabel}`));
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs(EditorStack, { gap: 1, children: [
    /* @__PURE__ */ jsx("label", { htmlFor: switchIdRef.current, className: styles.switchLabel, children: label }),
    /* @__PURE__ */ jsx(Switch, { ...inputProps, id: switchIdRef.current })
  ] });
}
const getStyles = (theme) => {
  return {
    switchLabel: css({
      color: theme.colors.text.secondary,
      cursor: "pointer",
      fontSize: theme.typography.bodySmall.fontSize,
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
};

export { QueryHeaderSwitch };
//# sourceMappingURL=QueryHeaderSwitch.js.map
