import { jsx } from 'react/jsx-runtime';
import { isString } from 'lodash';
import { Utils, BasicConfig } from '@react-awesome-query-builder/ui';
import { dateTime, toOption } from '@grafana/data';
import { Input, DateTimePicker, Select, Button } from '@grafana/ui';

const buttonLabels = {
  add: "Add",
  remove: "Remove"
};
({
  id: Utils.uuid(),
  type: "group",
  children1: [
    {
      id: Utils.uuid(),
      type: "rule",
      properties: {
        field: null,
        operator: null,
        value: [],
        valueSrc: []
      }
    }
  ]
});
const emptyInitTree = {
  id: Utils.uuid(),
  type: "group",
  children1: [
    {
      id: Utils.uuid(),
      type: "rule",
      properties: {
        field: null,
        operator: null,
        value: [],
        valueSrc: []
      }
    }
  ]
};
const widgets = {
  ...BasicConfig.widgets,
  text: {
    ...BasicConfig.widgets.text,
    factory: function TextInput(props) {
      return /* @__PURE__ */ jsx(
        Input,
        {
          value: (props == null ? undefined : props.value) || "",
          placeholder: props == null ? undefined : props.placeholder,
          onChange: (e) => props == null ? undefined : props.setValue(e.currentTarget.value)
        }
      );
    }
  },
  number: {
    ...BasicConfig.widgets.number,
    factory: function NumberInput(props) {
      return /* @__PURE__ */ jsx(
        Input,
        {
          value: props == null ? undefined : props.value,
          placeholder: props == null ? undefined : props.placeholder,
          type: "number",
          onChange: (e) => props == null ? undefined : props.setValue(Number.parseInt(e.currentTarget.value, 10))
        }
      );
    }
  },
  datetime: {
    ...BasicConfig.widgets.datetime,
    factory: function DateTimeInput(props) {
      return /* @__PURE__ */ jsx(
        DateTimePicker,
        {
          onChange: (e) => {
            props == null ? undefined : props.setValue(e == null ? undefined : e.format(BasicConfig.widgets.datetime.valueFormat));
          },
          date: dateTime(props == null ? undefined : props.value).utc()
        }
      );
    }
  }
};
const settings = {
  ...BasicConfig.settings,
  canRegroup: false,
  maxNesting: 1,
  canReorder: false,
  showNot: false,
  addRuleLabel: buttonLabels.add,
  deleteLabel: buttonLabels.remove,
  renderConjs: function Conjunctions(conjProps) {
    return /* @__PURE__ */ jsx(
      Select,
      {
        id: conjProps == null ? undefined : conjProps.id,
        "aria-label": "Conjunction",
        menuShouldPortal: true,
        options: (conjProps == null ? undefined : conjProps.conjunctionOptions) ? Object.keys(conjProps == null ? undefined : conjProps.conjunctionOptions).map(toOption) : undefined,
        value: conjProps == null ? undefined : conjProps.selectedConjunction,
        onChange: (val) => conjProps == null ? undefined : conjProps.setConjunction(val.value)
      }
    );
  },
  renderField: function Field(fieldProps) {
    var _a;
    const fields = ((_a = fieldProps == null ? undefined : fieldProps.config) == null ? undefined : _a.fields) || {};
    return /* @__PURE__ */ jsx(
      Select,
      {
        id: fieldProps == null ? undefined : fieldProps.id,
        width: 25,
        "aria-label": "Field",
        menuShouldPortal: true,
        options: fieldProps == null ? undefined : fieldProps.items.map((f) => {
          var _a2, _b;
          const icon = (_b = (_a2 = fields[f.key].mainWidgetProps) == null ? undefined : _a2.customProps) == null ? undefined : _b.icon;
          return {
            label: f.label,
            value: f.key,
            icon
          };
        }),
        value: fieldProps == null ? undefined : fieldProps.selectedKey,
        onChange: (val) => {
          fieldProps == null ? undefined : fieldProps.setField(val.label);
        }
      }
    );
  },
  renderButton: function RAQBButton(buttonProps) {
    return /* @__PURE__ */ jsx(
      Button,
      {
        type: "button",
        title: `${buttonProps == null ? undefined : buttonProps.label} filter`,
        onClick: buttonProps == null ? undefined : buttonProps.onClick,
        variant: "secondary",
        size: "md",
        icon: (buttonProps == null ? undefined : buttonProps.label) === buttonLabels.add ? "plus" : "times"
      }
    );
  },
  renderOperator: function Operator(operatorProps) {
    return /* @__PURE__ */ jsx(
      Select,
      {
        options: operatorProps == null ? undefined : operatorProps.items.map((op) => ({ label: op.label, value: op.key })),
        "aria-label": "Operator",
        menuShouldPortal: true,
        value: operatorProps == null ? undefined : operatorProps.selectedKey,
        onChange: (val) => {
          operatorProps == null ? undefined : operatorProps.setField(val.value || "");
        }
      }
    );
  }
};
const customOperators = getCustomOperators(BasicConfig);
const textWidget = BasicConfig.types.text.widgets.text;
const opers = [...textWidget.operators || [], "select_any_in" /* IN */, "select_not_any_in" /* NOT_IN */];
const customTextWidget = {
  ...textWidget,
  operators: opers
};
const customTypes = {
  ...BasicConfig.types,
  text: {
    ...BasicConfig.types.text,
    widgets: {
      ...BasicConfig.types.text.widgets,
      text: customTextWidget
    }
  }
};
const raqbConfig = {
  ...BasicConfig,
  widgets,
  settings,
  operators: customOperators,
  types: customTypes
};
function getCustomOperators(config) {
  const { ...supportedOperators } = config.operators;
  const noop = () => "";
  const sqlFormatInOp = supportedOperators["select_any_in" /* IN */].sqlFormatOp || noop;
  const customSqlInFormatter = (field, op, value, valueSrc, valueType, opDef, operatorOptions, fieldDef) => sqlFormatInOp.call(
    config.ctx,
    field,
    op,
    splitIfString(value),
    valueSrc,
    valueType,
    opDef,
    operatorOptions,
    fieldDef
  );
  const sqlFormatNotInOp = supportedOperators["select_not_any_in" /* NOT_IN */].sqlFormatOp || noop;
  const customSqlNotInFormatter = (field, op, value, valueSrc, valueType, opDef, operatorOptions, fieldDef) => sqlFormatNotInOp.call(
    config.ctx,
    field,
    op,
    splitIfString(value),
    valueSrc,
    valueType,
    opDef,
    operatorOptions,
    fieldDef
  );
  const customOperators2 = {
    ...supportedOperators,
    ["select_any_in" /* IN */]: {
      ...supportedOperators["select_any_in" /* IN */],
      sqlFormatOp: customSqlInFormatter
    },
    ["select_not_any_in" /* NOT_IN */]: {
      ...supportedOperators["select_not_any_in" /* NOT_IN */],
      sqlFormatOp: customSqlNotInFormatter
    }
  };
  return customOperators2;
}
function splitIfString(value) {
  if (isString(value)) {
    return value.split(",");
  }
  return value;
}

export { emptyInitTree, raqbConfig, settings, widgets };
//# sourceMappingURL=AwesomeQueryBuilder.js.map
