import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import 'react';
import { AuthMethodSettings } from './auth-method/AuthMethodSettings.js';
import { TLSSettings } from './tls/TLSSettings.js';
import '@grafana/ui';
import { CustomHeaders } from './custom-headers/CustomHeaders.js';
import { ConfigSection } from '../ConfigSection/ConfigSection.js';
import '@grafana/data';

const Auth = ({
  selectedMethod,
  mostCommonMethod,
  visibleMethods,
  defaultOptionsOverrides,
  customMethods,
  onAuthMethodSelect,
  basicAuth,
  TLS,
  customHeaders,
  readOnly = false
}) => {
  const styles = {
    container: css({
      maxWidth: 578
    })
  };
  return /* @__PURE__ */ jsx("div", { className: styles.container, children: /* @__PURE__ */ jsxs(ConfigSection, { title: "Authentication", children: [
    /* @__PURE__ */ jsx(
      AuthMethodSettings,
      {
        selectedMethod,
        mostCommonMethod,
        customMethods,
        visibleMethods,
        defaultOptionsOverrides,
        onAuthMethodSelect,
        basicAuth,
        readOnly
      }
    ),
    TLS && /* @__PURE__ */ jsx(TLSSettings, { ...TLS, readOnly }),
    customHeaders && /* @__PURE__ */ jsx(CustomHeaders, { ...customHeaders, readOnly })
  ] }) });
};

export { Auth };
//# sourceMappingURL=Auth.js.map
