/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPUtil;
import org.bouncycastle.util.Arrays;

public abstract class PBEKeyEncryptionMethodGenerator
implements PGPKeyEncryptionMethodGenerator {
    private char[] passPhrase;
    private PGPDigestCalculator s2kDigestCalculator;
    private S2K s2k;
    private SecureRandom random;
    private int s2kCount;
    private int wrapAlg = -1;

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        this(cArray, pGPDigestCalculator, 96);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        this.passPhrase = cArray;
        this.s2k = new S2K(argon2Params);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        this.passPhrase = cArray;
        this.s2kDigestCalculator = pGPDigestCalculator;
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = n;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PBEKeyEncryptionMethodGenerator setSessionKeyWrapperAlgorithm(int n) {
        this.wrapAlg = n;
        return this;
    }

    public int getSessionKeyWrapperAlgorithm(int n) {
        if (this.wrapAlg < 0) {
            return n;
        }
        return this.wrapAlg;
    }

    public byte[] getKey(int n) throws PGPException {
        if (this.s2k == null) {
            byte[] byArray = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), byArray, this.s2kCount);
        }
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, n, this.s2k, this.passPhrase);
    }

    @Override
    public ContainedPacket generate(PGPDataEncryptorBuilder pGPDataEncryptorBuilder, byte[] byArray) throws PGPException {
        int n = this.getSessionKeyWrapperAlgorithm(pGPDataEncryptorBuilder.getAlgorithm());
        if (pGPDataEncryptorBuilder.getAeadAlgorithm() <= 0) {
            if (byArray == null) {
                return SymmetricKeyEncSessionPacket.createV4Packet(n, this.s2k, null);
            }
            byte[] byArray2 = this.getKey(n);
            return SymmetricKeyEncSessionPacket.createV4Packet(n, this.s2k, this.encryptSessionInfo(n, byArray2, Arrays.prepend((byte[])byArray, (byte)((byte)pGPDataEncryptorBuilder.getAlgorithm()))));
        }
        int n2 = pGPDataEncryptorBuilder.getAeadAlgorithm();
        int n3 = pGPDataEncryptorBuilder.isV5StyleAEAD() ? 5 : 6;
        byte[] byArray3 = this.getKey(n);
        byte[] byArray4 = new byte[]{-61, (byte)n3, (byte)n, (byte)n2};
        if (n3 == 6) {
            byArray3 = this.generateV6KEK(n, byArray3, byArray4);
        }
        byte[] byArray5 = new byte[AEADUtils.getIVLength(n2)];
        this.random.nextBytes(byArray5);
        int n4 = AEADUtils.getAuthTagLength(n2);
        byte[] byArray6 = this.getEskAndTag(n, n2, byArray, byArray3, byArray5, byArray4);
        byte[] byArray7 = Arrays.copyOfRange((byte[])byArray6, (int)0, (int)(byArray6.length - n4));
        byte[] byArray8 = Arrays.copyOfRange((byte[])byArray6, (int)byArray7.length, (int)byArray6.length);
        if (n3 == 5) {
            return SymmetricKeyEncSessionPacket.createV5Packet(n, n2, byArray5, this.s2k, byArray7, byArray8);
        }
        return SymmetricKeyEncSessionPacket.createV6Packet(n, n2, byArray5, this.s2k, byArray7, byArray8);
    }

    protected abstract byte[] encryptSessionInfo(int var1, byte[] var2, byte[] var3) throws PGPException;

    protected abstract byte[] getEskAndTag(int var1, int var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws PGPException;

    protected abstract byte[] generateV6KEK(int var1, byte[] var2, byte[] var3) throws PGPException;
}

