/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MappingProvider<OUT, IN>
extends TransformBackedProvider<OUT, IN> {
    public MappingProvider(@Nullable Class<OUT> type, ProviderInternal<? extends IN> provider, Transformer<? extends OUT, ? super IN> transformer) {
        super(type, provider, transformer);
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationScopeContext ignored = this.openScope();){
            boolean bl = this.provider.calculatePresence(consumer);
            return bl;
        }
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends OUT> calculateExecutionTimeValue() {
        try (EvaluationScopeContext context = this.openScope();){
            ValueSupplier.ExecutionTimeValue value = this.provider.calculateExecutionTimeValue();
            if (value.isChangingValue()) {
                ValueSupplier.ExecutionTimeValue executionTimeValue = ValueSupplier.ExecutionTimeValue.changingValue(new MappingProvider(this.type, value.getChangingValue(), this.transformer));
                return executionTimeValue;
            }
            ValueSupplier.ExecutionTimeValue<OUT> executionTimeValue = ValueSupplier.ExecutionTimeValue.value(this.mapValue(context, value.toValue()));
            return executionTimeValue;
        }
    }

    @Override
    protected  @NonNull ValueSupplier.Value<OUT> mapValue(EvaluationScopeContext context, ValueSupplier.Value<? extends IN> value) {
        ValueSupplier.Value transformedValue = super.mapValue(context, value);
        if (!value.isMissing() && transformedValue.isMissing()) {
            throw new IllegalStateException("The transformer in MappingProvider must always return a value");
        }
        return transformedValue;
    }

    @Override
    protected void beforeRead(EvaluationScopeContext context) {
    }

    @Override
    protected String toStringNoReentrance() {
        return "map(" + (this.type == null ? "" : this.type.getName() + " ") + this.provider + " " + this.transformer + ")";
    }
}

