/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.gradle.internal.cc.impl.IgnoredConfigurationInputs;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheStartParameter;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.GFileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gradle/internal/cc/impl/DefaultIgnoredConfigurationInputs;", "Lorg/gradle/internal/cc/impl/IgnoredConfigurationInputs;", "ignoredPathsString", "", "isCaseSensitive", "", "buildTreeRootDirectory", "Ljava/io/File;", "<init>", "(Ljava/lang/String;ZLjava/io/File;)V", "configurationCacheStartParameter", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;", "fileSystem", "Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;", "(Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;)V", "userHome", "jointRegex", "Lkotlin/text/Regex;", "isFileSystemCheckIgnoredFor", "file", "normalizeActualInputPath", "normalizeFilePattern", "pathWithWildcards", "substituteUserHome", "maybeRelativize", "wildcardsToRegexPatternString", "maybeCreateJointRegexForPatterns", "paths", "Companion", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nDefaultIgnoredConfigurationInputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultIgnoredConfigurationInputs.kt\norg/gradle/internal/cc/impl/DefaultIgnoredConfigurationInputs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class DefaultIgnoredConfigurationInputs
implements IgnoredConfigurationInputs {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final File buildTreeRootDirectory;
    @NotNull
    private final File userHome;
    @Nullable
    private final Regex jointRegex;
    @Deprecated
    @NotNull
    public static final String PATHS_SEPARATOR = ";";

    public DefaultIgnoredConfigurationInputs(@Nullable String ignoredPathsString, boolean isCaseSensitive, @NotNull File buildTreeRootDirectory) {
        Intrinsics.checkNotNullParameter((Object)buildTreeRootDirectory, (String)"buildTreeRootDirectory");
        this.buildTreeRootDirectory = buildTreeRootDirectory;
        this.userHome = new File(System.getProperty("user.home"));
        this.jointRegex = this.maybeCreateJointRegexForPatterns(ignoredPathsString, isCaseSensitive);
    }

    @Inject
    public DefaultIgnoredConfigurationInputs(@NotNull ConfigurationCacheStartParameter configurationCacheStartParameter, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)configurationCacheStartParameter, (String)"configurationCacheStartParameter");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this(configurationCacheStartParameter.getIgnoredFileSystemCheckInputs(), fileSystem.isCaseSensitive(), configurationCacheStartParameter.getBuildTreeRootDirectory());
    }

    @Override
    public boolean isFileSystemCheckIgnoredFor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Regex regex = this.jointRegex;
        return regex != null ? regex.matches((CharSequence)this.normalizeActualInputPath(file)) : false;
    }

    private final String normalizeActualInputPath(File file) {
        File p0 = file;
        boolean bl = false;
        p0 = this.maybeRelativize(p0);
        boolean bl2 = false;
        return FilesKt.getInvariantSeparatorsPath((File)FilesKt.normalize((File)p0));
    }

    private final String normalizeFilePattern(String pathWithWildcards) {
        File p0 = new File(pathWithWildcards);
        boolean bl = false;
        p0 = this.substituteUserHome(p0);
        boolean bl2 = false;
        p0 = this.maybeRelativize(p0);
        boolean bl3 = false;
        return FilesKt.getInvariantSeparatorsPath((File)FilesKt.normalize((File)p0));
    }

    private final File substituteUserHome(File file) {
        File file2;
        if (StringsKt.startsWith$default((String)FilesKt.getInvariantSeparatorsPath((File)file), (String)"~/", (boolean)false, (int)2, null)) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            file2 = new File(this.userHome, StringsKt.substringAfter$default((String)string, (char)File.separatorChar, null, (int)2, null));
        } else {
            file2 = file;
        }
        return file2;
    }

    private final File maybeRelativize(File file) {
        return !file.isAbsolute() ? file : new File(GFileUtils.relativePathOf((File)file, (File)this.buildTreeRootDirectory));
    }

    private final String wildcardsToRegexPatternString(String pathWithWildcards) {
        String[] stringArray = new String[]{"**"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)pathWithWildcards, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)".*", (CharSequence)"^", (CharSequence)"$", (int)0, null, DefaultIgnoredConfigurationInputs::wildcardsToRegexPatternString$lambda$6, (int)24, null);
    }

    private final Regex maybeCreateJointRegexForPatterns(String paths, boolean isCaseSensitive) {
        Regex regex;
        Object object = (String[])paths;
        if (object == null || object.length() == 0) {
            regex = null;
        } else {
            Set set;
            object = new String[]{PATHS_SEPARATOR};
            object = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)paths, (String[])object, (boolean)false, (int)0, (int)6, null), (CharSequence)"|", null, null, (int)0, null, arg_0 -> DefaultIgnoredConfigurationInputs.maybeCreateJointRegexForPatterns$lambda$7(this, arg_0), (int)30, null);
            if (!isCaseSensitive) {
                EnumSet<Enum> enumSet = EnumSet.of((Enum)RegexOption.IGNORE_CASE);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
                set = enumSet;
            } else {
                set = SetsKt.emptySet();
            }
            Set set2 = set;
            regex = new Regex((String)object, set2);
        }
        return regex;
    }

    private static final String wildcardsToRegexPatternString$runIfNotEmpty(String $this$wildcardsToRegexPatternString_u24runIfNotEmpty, Function1<? super String, String> action) {
        return ((CharSequence)$this$wildcardsToRegexPatternString_u24runIfNotEmpty).length() == 0 ? $this$wildcardsToRegexPatternString_u24runIfNotEmpty : (String)action.invoke((Object)$this$wildcardsToRegexPatternString_u24runIfNotEmpty);
    }

    private static final CharSequence wildcardsToRegexPatternString$lambda$6$lambda$5$lambda$4(String innerPart) {
        Intrinsics.checkNotNullParameter((Object)innerPart, (String)"innerPart");
        return DefaultIgnoredConfigurationInputs.wildcardsToRegexPatternString$runIfNotEmpty(innerPart, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Regex.Companion){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Regex.Companion)this.receiver).escape(p0);
            }
        }));
    }

    private static final String wildcardsToRegexPatternString$lambda$6$lambda$5(String $this$runIfNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$runIfNotEmpty, (String)"$this$runIfNotEmpty");
        String[] stringArray = new String[]{"*"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$runIfNotEmpty, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"[^/]*", null, null, (int)0, null, DefaultIgnoredConfigurationInputs::wildcardsToRegexPatternString$lambda$6$lambda$5$lambda$4, (int)30, null);
    }

    private static final CharSequence wildcardsToRegexPatternString$lambda$6(String outerPart) {
        Intrinsics.checkNotNullParameter((Object)outerPart, (String)"outerPart");
        return DefaultIgnoredConfigurationInputs.wildcardsToRegexPatternString$runIfNotEmpty(outerPart, (Function1<? super String, String>)((Function1)DefaultIgnoredConfigurationInputs::wildcardsToRegexPatternString$lambda$6$lambda$5));
    }

    private static final CharSequence maybeCreateJointRegexForPatterns$lambda$7(DefaultIgnoredConfigurationInputs this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.wildcardsToRegexPatternString(this$0.normalizeFilePattern(it));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gradle/internal/cc/impl/DefaultIgnoredConfigurationInputs$Companion;", "", "<init>", "()V", "PATHS_SEPARATOR", "", "configuration-cache"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

