/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.problems.AdditionalData;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.FileLocation;
import org.gradle.api.problems.LineInFileLocation;
import org.gradle.api.problems.OffsetInFileLocation;
import org.gradle.api.problems.ProblemDefinition;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultProblemProgressDetails;
import org.gradle.api.problems.internal.DefaultProblemsSummaryProgressDetails;
import org.gradle.api.problems.internal.DeprecationData;
import org.gradle.api.problems.internal.GeneralData;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.PluginIdLocation;
import org.gradle.api.problems.internal.ProblemSummaryData;
import org.gradle.api.problems.internal.StackTraceLocation;
import org.gradle.api.problems.internal.TaskLocation;
import org.gradle.api.problems.internal.TypeValidationData;
import org.gradle.api.problems.internal.TypedAdditionalData;
import org.gradle.internal.build.event.types.DefaultContextualLabel;
import org.gradle.internal.build.event.types.DefaultDetails;
import org.gradle.internal.build.event.types.DefaultDocumentationLink;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultFileLocation;
import org.gradle.internal.build.event.types.DefaultInternalAdditionalData;
import org.gradle.internal.build.event.types.DefaultInternalPayloadSerializedAdditionalData;
import org.gradle.internal.build.event.types.DefaultLineInFileLocation;
import org.gradle.internal.build.event.types.DefaultOffsetInFileLocation;
import org.gradle.internal.build.event.types.DefaultPluginIdLocation;
import org.gradle.internal.build.event.types.DefaultProblemDefinition;
import org.gradle.internal.build.event.types.DefaultProblemDescriptor;
import org.gradle.internal.build.event.types.DefaultProblemDetails;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.internal.build.event.types.DefaultProblemGroup;
import org.gradle.internal.build.event.types.DefaultProblemId;
import org.gradle.internal.build.event.types.DefaultProblemSummary;
import org.gradle.internal.build.event.types.DefaultProblemsSummariesDetails;
import org.gradle.internal.build.event.types.DefaultSeverity;
import org.gradle.internal.build.event.types.DefaultSolution;
import org.gradle.internal.build.event.types.DefaultTaskPathLocation;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.InternalProblemDefinition;
import org.gradle.tooling.internal.protocol.InternalProblemEventVersion2;
import org.gradle.tooling.internal.protocol.InternalProblemGroup;
import org.gradle.tooling.internal.protocol.InternalProblemId;
import org.gradle.tooling.internal.protocol.events.InternalProblemDescriptor;
import org.gradle.tooling.internal.protocol.problem.InternalAdditionalData;
import org.gradle.tooling.internal.protocol.problem.InternalContextualLabel;
import org.gradle.tooling.internal.protocol.problem.InternalDetails;
import org.gradle.tooling.internal.protocol.problem.InternalDocumentationLink;
import org.gradle.tooling.internal.protocol.problem.InternalLocation;
import org.gradle.tooling.internal.protocol.problem.InternalProblemDetailsVersion2;
import org.gradle.tooling.internal.protocol.problem.InternalSeverity;
import org.gradle.tooling.internal.protocol.problem.InternalSolution;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ProblemsProgressEventUtils {
    private static final InternalSeverity ADVICE = new DefaultSeverity(0);
    private static final InternalSeverity WARNING = new DefaultSeverity(1);
    private static final InternalSeverity ERROR = new DefaultSeverity(2);

    static InternalProblemEventVersion2 createProblemEvent(OperationIdentifier buildOperationId, DefaultProblemProgressDetails details, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        InternalProblem problem = details.getProblem();
        return new DefaultProblemEvent(ProblemsProgressEventUtils.createDefaultProblemDescriptor(buildOperationId, operationIdentifierSupplier), (InternalProblemDetailsVersion2)ProblemsProgressEventUtils.createDefaultProblemDetails(problem));
    }

    static InternalProblemEventVersion2 createProblemSummaryEvent(@Nullable OperationIdentifier buildOperationId, DefaultProblemsSummaryProgressDetails details, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        return ProblemsProgressEventUtils.createProblemSummaryEvent(buildOperationId, details.getProblemIdCounts(), operationIdentifierSupplier);
    }

    private static InternalProblemEventVersion2 createProblemSummaryEvent(OperationIdentifier buildOperationId, List<ProblemSummaryData> problemIdCounts, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        List internalIdCounts = (List)problemIdCounts.stream().map(it -> new DefaultProblemSummary(ProblemsProgressEventUtils.toInternalId(it.getProblemId()), Integer.valueOf(it.getCount()))).collect(ImmutableList.toImmutableList());
        return new DefaultProblemEvent(ProblemsProgressEventUtils.createDefaultProblemDescriptor(buildOperationId, operationIdentifierSupplier), (InternalProblemDetailsVersion2)new DefaultProblemsSummariesDetails(internalIdCounts));
    }

    private static @Nullable InternalFailure toInternalFailure(@Nullable Throwable ex) {
        if (ex == null) {
            return null;
        }
        return DefaultFailure.fromThrowable((Throwable)ex);
    }

    private static InternalProblemDescriptor createDefaultProblemDescriptor(OperationIdentifier parentBuildOperationId, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        return new DefaultProblemDescriptor(operationIdentifierSupplier.get(), parentBuildOperationId);
    }

    static DefaultProblemDetails createDefaultProblemDetails(InternalProblem problem) {
        return new DefaultProblemDetails(ProblemsProgressEventUtils.toInternalDefinition(problem.getDefinition()), ProblemsProgressEventUtils.toInternalDetails(problem.getDetails()), ProblemsProgressEventUtils.toInternalContextualLabel(problem.getContextualLabel()), ProblemsProgressEventUtils.toInternalLocations(problem.getOriginLocations()), ProblemsProgressEventUtils.toInternalLocations(problem.getContextualLocations()), ProblemsProgressEventUtils.toInternalSolutions(problem.getSolutions()), ProblemsProgressEventUtils.toInternalAdditionalData(problem), ProblemsProgressEventUtils.toInternalFailure(problem.getException()));
    }

    private static InternalProblemDefinition toInternalDefinition(ProblemDefinition definition) {
        return new DefaultProblemDefinition(ProblemsProgressEventUtils.toInternalId(definition.getId()), ProblemsProgressEventUtils.toInternalSeverity(definition.getSeverity()), ProblemsProgressEventUtils.toInternalDocumentationLink(definition.getDocumentationLink()));
    }

    private static InternalProblemId toInternalId(ProblemId problemId) {
        return new DefaultProblemId(problemId.getName(), problemId.getDisplayName(), ProblemsProgressEventUtils.toInternalGroup(problemId.getGroup()));
    }

    private static InternalProblemGroup toInternalGroup(ProblemGroup group) {
        return new DefaultProblemGroup(group.getName(), group.getDisplayName(), group.getParent() == null ? null : ProblemsProgressEventUtils.toInternalGroup(group.getParent()));
    }

    private static @Nullable InternalContextualLabel toInternalContextualLabel(@Nullable String contextualLabel) {
        return contextualLabel == null ? null : new DefaultContextualLabel(contextualLabel);
    }

    private static @Nullable InternalDetails toInternalDetails(@Nullable String details) {
        return details == null ? null : new DefaultDetails(details);
    }

    private static InternalSeverity toInternalSeverity(Severity severity) {
        switch (severity) {
            case ADVICE: {
                return ADVICE;
            }
            case WARNING: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
        }
        throw new RuntimeException("No mapping defined for severity level " + severity);
    }

    private static List<InternalLocation> toInternalLocations(List<ProblemLocation> locations) {
        return (List)locations.stream().filter(location -> !(location instanceof StackTraceLocation) || ((StackTraceLocation)location).getFileLocation() != null).map(location -> location instanceof StackTraceLocation ? ((StackTraceLocation)location).getFileLocation() : location).map(location -> {
            if (location instanceof LineInFileLocation) {
                LineInFileLocation fileLocation = (LineInFileLocation)location;
                return new DefaultLineInFileLocation(fileLocation.getPath(), fileLocation.getLine(), fileLocation.getColumn(), fileLocation.getLength());
            }
            if (location instanceof OffsetInFileLocation) {
                OffsetInFileLocation fileLocation = (OffsetInFileLocation)location;
                return new DefaultOffsetInFileLocation(fileLocation.getPath(), fileLocation.getOffset(), fileLocation.getLength());
            }
            if (location instanceof FileLocation) {
                FileLocation fileLocation = (FileLocation)location;
                return new DefaultFileLocation(fileLocation.getPath());
            }
            if (location instanceof PluginIdLocation) {
                PluginIdLocation pluginLocation = (PluginIdLocation)location;
                return new DefaultPluginIdLocation(pluginLocation.getPluginId());
            }
            if (location instanceof TaskLocation) {
                TaskLocation taskLocation = (TaskLocation)location;
                return new DefaultTaskPathLocation(taskLocation.getBuildTreePath());
            }
            throw new RuntimeException("No mapping defined for " + location.getClass().getName());
        }).collect(ImmutableList.toImmutableList());
    }

    private static @Nullable InternalDocumentationLink toInternalDocumentationLink(@Nullable DocLink link) {
        return link == null || link.getUrl() == null ? null : new DefaultDocumentationLink(link.getUrl());
    }

    private static List<InternalSolution> toInternalSolutions(List<String> solutions) {
        return (List)solutions.stream().map(DefaultSolution::new).collect(ImmutableList.toImmutableList());
    }

    private static InternalAdditionalData toInternalAdditionalData(InternalProblem problem) {
        AdditionalData additionalData = problem.getAdditionalData();
        if (additionalData instanceof DeprecationData) {
            DeprecationData data = (DeprecationData)additionalData;
            return new DefaultInternalAdditionalData((Map)ImmutableMap.of((Object)"type", (Object)data.getType().name()));
        }
        if (additionalData instanceof TypeValidationData) {
            TypeValidationData data = (TypeValidationData)additionalData;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Optional.ofNullable(data.getPluginId()).ifPresent(pluginId -> builder.put((Object)"pluginId", pluginId));
            Optional.ofNullable(data.getPropertyName()).ifPresent(propertyName -> builder.put((Object)"propertyName", propertyName));
            Optional.ofNullable(data.getParentPropertyName()).ifPresent(parentPropertyName -> builder.put((Object)"parentPropertyName", parentPropertyName));
            Optional.ofNullable(data.getTypeName()).ifPresent(typeName -> builder.put((Object)"typeName", typeName));
            return new DefaultInternalAdditionalData((Map)builder.build());
        }
        if (additionalData instanceof GeneralData) {
            GeneralData data = (GeneralData)additionalData;
            return new DefaultInternalAdditionalData(data.getAsMap().entrySet().stream().filter(entry -> ProblemsProgressEventUtils.isSupportedType(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (additionalData instanceof TypedAdditionalData) {
            TypedAdditionalData typedData = (TypedAdditionalData)additionalData;
            return new DefaultInternalPayloadSerializedAdditionalData(typedData.getBytesForIsolatedObject(), typedData.getSerializedType());
        }
        return new DefaultInternalAdditionalData(Collections.emptyMap());
    }

    private static boolean isSupportedType(Object type) {
        return type instanceof String;
    }
}

