/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.google.common.collect.Interner;
import java.util.Optional;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.AbstractFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.PathUtil;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.VfsRelativePath;

public class MissingFileSnapshot
extends AbstractFileSystemLocationSnapshot
implements FileSystemLeafSnapshot {
    private static final HashCode SIGNATURE = Hashing.signature(MissingFileSnapshot.class);

    public MissingFileSnapshot(String absolutePath, String name, FileMetadata.AccessType accessType) {
        super(absolutePath, name, accessType);
    }

    public MissingFileSnapshot(String absolutePath, FileMetadata.AccessType accessType) {
        this(absolutePath, PathUtil.getFileName(absolutePath), accessType);
    }

    protected Optional<MissingFileSnapshot> relocateDirectAccess(String targetPath, String name, Interner<String> interner) {
        return Optional.of(new MissingFileSnapshot(targetPath, name, this.getAccessType()));
    }

    @Override
    public FileType getType() {
        return FileType.Missing;
    }

    @Override
    public HashCode getHash() {
        return SIGNATURE;
    }

    @Override
    public boolean isContentAndMetadataUpToDate(FileSystemLocationSnapshot other) {
        return this.isContentUpToDate(other);
    }

    @Override
    public boolean isContentUpToDate(FileSystemLocationSnapshot other) {
        return other instanceof MissingFileSnapshot;
    }

    @Override
    public void accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor visitor) {
        visitor.visitMissing(this);
    }

    @Override
    public <T> T accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<T> transformer) {
        return transformer.visitMissing(this);
    }

    @Override
    public Optional<FileSystemNode> invalidate(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, SnapshotHierarchy.NodeDiffListener diffListener) {
        diffListener.nodeRemoved(this);
        return Optional.empty();
    }

    @Override
    public String toString() {
        return String.format("%s/%s", super.toString(), this.getName());
    }
}

